#!/bin/sh
#
# config-video.sh: configure values for installed video libraries into config.h
#

# read in parameters
read CC
test "$CC" = "" && CC="cc"
read CPP
test "$CPP" = "" && CPP="cc -E"
read sharedir

# check echo
ECHO="echo"; ECHOSTRIP="\c"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && ECHO="echo -e"
test "`$ECHO \"$ECHOSTRIP\"`" != "" && { ECHO="echo -n"; ECHOSTRIP=""; }


# ***********************************************
# ***** check for installed video libraries *****
# ***********************************************

echo
echo "==> Check for video libraries ..."
(echo; echo) >> config.log
echo "###########################" >> config.log
echo "### Video Library Tests ###" >> config.log
echo "###########################" >> config.log


# +++++++++++++++++++++++++
# +++ check for svgalib +++
# +++++++++++++++++++++++++

$ECHO "Svgalib installed (for compiling)?      $ECHOSTRIP"
(echo; echo "*** Svgalib installed (for compiling)? ***") >> config.log

rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <vga.h>
#include <vgagl.h>
#include <vgamouse.h>
#include <vgakeyboard.h>
int main() {
  vga_init();
  vga_setmode(TEXT);
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC -c _xt.c") >> config.log
$CC -c _xt.c 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
if test $x -ne 0
then
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_SVGALIB */" >> config.h
  rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_SVGALIB##%0%" > _vg2; mv -f _vg2 _vg2.cf
  rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_SVGALIB##%0%" > _vg2; mv -f _vg2 _vg2.mk
else
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_SVGALIB" >> config.h
  rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_SVGALIB##%1%" > _vg2; mv -f _vg2 _vg2.cf
  rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_SVGALIB##%1%" > _vg2; mv -f _vg2 _vg2.mk
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# ++++++++++++++++++++++++
# +++ check for libvgl +++
# ++++++++++++++++++++++++

$ECHO "Libvgl installed (for compiling)?       $ECHOSTRIP"
(echo; echo "*** Libvgl installed (for compiling)? ***") >> config.log

# FreeBSD4
rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <machine/console.h>
#include <vgl.h>
int main() {
  VGLInit(SW_VGA_CG320);
  VGLEnd();
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC -c _xt.c") >> config.log
$CC -c _xt.c 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
if test $x -ne 0
then
  $ECHO "hmm, $ECHOSTRIP"
  (echo; echo "==> not for FreeBSD4 <==") >> config.log
  echo "/* #undef HAVE_VGL4 */" >> config.h
  rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_VGL4##%0%" > _vg2; mv -f _vg2 _vg2.cf
else
  $ECHO "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_VGL4" >> config.h
  rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_VGL4##%1%" > _vg2; mv -f _vg2 _vg2.cf
  rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_VGL##%1%" > _vg2; mv -f _vg2 _vg2.mk
fi

# FreeBSD5
if test $x -ne 0
then
  rm -f _xt.c _xt.o _xt
  cat > _xt.c <<__EOF__
#include <sys/fbio.h>
#include <sys/consio.h>
#include <sys/kbio.h>
#include <vgl.h>
int main() {
  VGLInit(SW_VGA_CG320);
  VGLEnd();
  return(0);
}
__EOF__
  (echo; echo "--> Begin test file _xt.c:") >> config.log
  cat _xt.c >> config.log
  echo "<-- End test file" >> config.log

  (echo; echo "--> Begin compiling error messages: $CC -c _xt.c") >> config.log
  $CC -c _xt.c 2>> config.log
  x=$?
  echo "<-- End compiling error messages" >> config.log
  if test $x -ne 0
  then
    echo "no"
    (echo; echo "==> no <==") >> config.log
    echo "/* #undef HAVE_VGL5 */" >> config.h
    rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_VGL5##%0%" > _vg2; mv -f _vg2 _vg2.cf
    rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_VGL##%0%" > _vg2; mv -f _vg2 _vg2.mk
  else
    echo "yes"
    (echo; echo "==> yes <==") >> config.log
    echo "#define HAVE_VGL5" >> config.h
    rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_VGL5##%1%" > _vg2; mv -f _vg2 _vg2.cf
    rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_VGL##%1%" > _vg2; mv -f _vg2 _vg2.mk
  fi
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# ++++++++++++++++++++++++++
# +++ check for X window +++
# ++++++++++++++++++++++++++

$ECHO "X window installed (for compiling)?     $ECHOSTRIP"
(echo; echo "*** X window installed (for compiling)? ***") >> config.log

# X window path
x11pfad=""
(echo; echo "--> Begin searching for X11 path") >> config.log
for pfad in /usr /opt /usr/local /usr/opt /usr/local/opt
do
  x11pfad=`./read_link $pfad include/X11/X.h`
  test "$x11pfad" != "" && { x11pfad="`dirname \`dirname $x11pfad\``"; echo "$x11pfad" >> config.log; break; }
done
echo "<-- End searching for X11 path" >> config.log
test "$x11pfad" = "" && x11pfad="/usr/X11"

# X window
rm -f _xt.c _xt.o _xt
cat > _xt.c <<__EOF__
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
int main() {
  return(0);
}
__EOF__
(echo; echo "--> Begin test file _xt.c:") >> config.log
cat _xt.c >> config.log
echo "<-- End test file" >> config.log

(echo; echo "--> Begin compiling error messages: $CC -I$x11pfad/include -c _xt.c") >> config.log
$CC -I$x11pfad/include -c _xt.c 2>> config.log
x=$?
echo "<-- End compiling error messages" >> config.log
rm -f _xt.c _xt.o _xt
if test $x -ne 0
then
  echo "no"
  (echo; echo "==> no <==") >> config.log
  echo "/* #undef HAVE_X11 */" >> config.h
  x11pfad="."
  rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_X11##%0%" > _vg2; mv -f _vg2 _vg2.cf
  rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_X11##%0%" > _vg2; mv -f _vg2 _vg2.mk
  rm -f _vg2; cat _vg2.cf | sed -e "s%##X11_PFAD##%$x11pfad%" > _vg2; mv -f _vg2 _vg2.cf
  rm -f _vg2; cat _vg2.mk | sed -e "s%##X11_PFAD##%$x11pfad%" > _vg2; mv -f _vg2 _vg2.mk
  echo "  --> you should have installed X window header files <--" >> config.log
  echo "  --> you should have installed X window header files <--"
  sleep 2
else
  echo "yes"
  (echo; echo "==> yes <==") >> config.log
  echo "#define HAVE_X11" >> config.h
  rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_X11##%1%" > _vg2; mv -f _vg2 _vg2.cf
  rm -f _vg2; cat _vg2.mk | sed -e "s%##HAVE_X11##%1%" > _vg2; mv -f _vg2 _vg2.mk
  rm -f _vg2; cat _vg2.cf | sed -e "s%##X11_PFAD##%$x11pfad%" > _vg2; mv -f _vg2 _vg2.cf
  rm -f _vg2; cat _vg2.mk | sed -e "s%##X11_PFAD##%$x11pfad%" > _vg2; mv -f _vg2 _vg2.mk
fi

# X window extensions
if test $x -eq 0
then
  $ECHO "X window extensions installed?          $ECHOSTRIP"
  (echo; echo "*** X window extensions installed? ***") >> config.log

  rm -f _xt.c _xt.o _xt
  cat > _xt.c <<__EOF__
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/xf86vmode.h>
int main() {
  Display * d=NULL;
  XF86VidModeModeInfo ** mi=NULL;
  XF86VidModeSwitchToMode(d,DefaultScreen(d),mi[0]);
  return(0);
}
__EOF__
  (echo; echo "--> Begin test file _xt.c:") >> config.log
  cat _xt.c >> config.log
  echo "<-- End test file" >> config.log

  (echo; echo "--> Begin compiling error messages: $CC -I$x11pfad/include _xt.c -L$x11pfad/lib64 -L$x11pfad/lib -lXxf86vm -lXext -lX11 -o _xt") >> config.log
  $CC -I$x11pfad/include _xt.c -L$x11pfad/lib64 -L$x11pfad/lib -lXxf86vm -lXext -lX11 -o _xt 2>> config.log
  x=$?
  echo "<-- End compiling error messages" >> config.log
  if test $x -ne 0
  then
    echo "no"
    (echo; echo "==> no <==") >> config.log
    echo "/* #undef HAVE_X11_EXTS */" >> config.h
    rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_X11_EXTS##%0%" > _vg2; mv -f _vg2 _vg2.cf
  else
    echo "yes"
    (echo; echo "==> yes <==") >> config.log
    echo "#define HAVE_X11_EXTS" >> config.h
    rm -f _vg2; cat _vg2.cf | sed -e "s%##HAVE_X11_EXTS##%1%" > _vg2; mv -f _vg2 _vg2.cf
  fi
else
  echo "/* #undef HAVE_X11_EXTS */" >> config.h
fi
(echo; echo "####################") >> config.log
rm -f _xt.c _xt.o _xt


# ++++++++++++++++++++++++
# +++ Video tests done +++
# ++++++++++++++++++++++++

echo "<== video library tests done"
exit 0
