/* *****************************************************************
   VgaGames2
   Copyright (C) 2000-2007 Kurt Nienhaus <vgagames@vgagames.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
   ***************************************************************** */

/* get game-directory */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

extern int read_link(const char *,char *,size_t,int);

int get_cwdir(const char *,char *,size_t);

int get_cwdir(const char * argv0,char * cwpath,size_t cwpathlen) {
/* return game-directory
** 1.arg: argv[0]
** 2.arg: address for game-directory
** 3.arg: sizeof 2.arg
** return:  0: OK
**         -1: error
*/
  const char * kptr;
  char pfad[1024],* ptr;
  if ((argv0==NULL) || (cwpath==NULL) || (cwpathlen<1)) {fprintf(stderr,"get_cwdir: invalid argument.\n"); return(-1);}
  if ((kptr=strrchr(argv0,'/'))==NULL) {  /* search environment $PATH */
    char * envpath;
    if ((envpath=getenv("PATH"))==NULL) {fprintf(stderr,"get_cwdir: cannot get environment variable PATH.\n"); return(-1);}
    for (ptr=strchr(envpath,':');;ptr=strchr(envpath,':')) {
      if (ptr==NULL) {ptr=envpath+strlen(envpath);}
      if (ptr>envpath) {
        snprintf(pfad,sizeof(pfad),"%.*s/%s",(int)(ptr-envpath),envpath,argv0);
        if (access(pfad,X_OK)==0) {argv0=pfad; break;}
      }
      if (*ptr=='\0') {argv0=NULL; break;}
      envpath=ptr+1;
    }
  }
  if (read_link(argv0,pfad,sizeof(pfad),0)<0) {fprintf(stderr,"get_cwdir: error calling read_link: %s.\n",pfad); return(-1);}
  if ((ptr=strrchr(pfad,'/'))==NULL) {fprintf(stderr,"get_cwdir: got no slash - impossible.\n"); return(-1);}
  *ptr='\0';
  snprintf(cwpath,cwpathlen,"%s",pfad);
  return(0);
} /* Ende get_cwdir */
