/* extsoundserver.h: try to stop/resume other sound servers */

#include <sys/mman.h>
#ifndef MAP_FILE
# define MAP_FILE 0
#endif
#ifndef MAP_FAILED
# define MAP_FAILED (void *)-1
#endif

#define NO_EXT_RESUME

void extsoundserver(int);
static void ssv_arts(int);
static void ssv_esd(int);

static void * memadr=NULL;
static char * memptr=NULL;
static const int memanz=8;
static int mempos=0;


void extsoundserver(int doit) {
/* 1.arg: 0=stop sound server
**        1=resume sound server
*/
  pid_t pid;

  if (doit==0) {  /* don't call system() as root */
    FILE * ffp;
    int fd;
    if ((ffp=tmpfile())==NULL) {  /* for shared memory between parent+child */
      fprintf(stderr,"tmpfile: %s\n",strerror(errno));
      return;
    }
    fd=fileno(ffp);
    if (write(fd,"################",memanz)!=(ssize_t)memanz) {
      fprintf(stderr,"write tmpfile: %s\n",strerror(errno));
      fclose(ffp);
      return;
    }
    if ((memadr=mmap(NULL,memanz,PROT_READ|PROT_WRITE,MAP_SHARED|MAP_FILE,fd,(off_t)0))==MAP_FAILED) {
      fprintf(stderr,"mmap tmpfile: %s\n",strerror(errno));
      fclose(ffp);
      return;
    }
    memptr=(char *)memadr;  /* for settings which sound server was running */
    fclose(ffp);

    if ((pid=fork())==(pid_t)-1) {
      fprintf(stderr,"fork: %s\n",strerror(errno));
      munmap(memadr,memanz);
      return;
    } else if (pid==0) {  /* child stops sound servers */
      setgid(getgid());
      setuid(getuid());
    } else {
      alarm(5);
      if (waitpid(pid,NULL,0)<0) {  /* wait for child */
        if (errno==EINTR) {kill(pid,SIGTERM);}
      }
      return;
    }

  } else {pid=(pid_t)-1;}

  mempos=0;
  ssv_arts(doit); mempos++;
  ssv_esd(doit); mempos++;

  if (pid==0) {munmap(memadr,memanz); exit(0);}  /* child exits */
} /* Ende extsoundserver */


static void ssv_arts(int doit) {
/* try to stop or resume arts sound server
** 1.arg: 0=stop it or 1=resume it
*/
  int erg;
  if (doit==0) {  /* stop */
    memptr[mempos]=0;
    erg=system("PATH=\"$PATH:/opt/kde/bin:/opt/kde2/bin:/opt/kde3/bin:/opt/kde4/bin\"; echo \"terminate\" | artsshell > /dev/null 2>&1");
    if (WEXITSTATUS(erg)==0) {memptr[mempos]=1;}
  } else if (memptr[mempos]==1) {  /* resume */
#ifndef NO_EXT_RESUME
    system("PATH=\"$PATH:/opt/kde/bin:/opt/kde2/bin:/opt/kde3/bin:/opt/kde4/bin\"; artswrapper > /dev/null 2>&1 &");
#else
    ;
#endif
  }
} /* Ende ssv_arts */


static void ssv_esd(int doit) {
/* try to stop or resume esd sound server
** 1.arg: 0=stop it or 1=resume it
*/
  int erg;
  if (doit==0) {  /* stop */
    memptr[mempos]=0;
    erg=system("esdctl off > /dev/null 2>&1");
    if (WEXITSTATUS(erg)==0) {memptr[mempos]=1;}
  } else if (memptr[mempos]==1) {  /* resume */
#ifndef NO_EXT_RESUME
    system("esdctl on > /dev/null 2>&1");
#else
    ;
#endif
  }
} /* Ende ssv_esd */
