/* Copyright (C) 1991, 1992, 1993 Free Software Foundation, Inc.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

/* Modified for the Linux C library by H.J. Lu (hlu@eecs.wsu.edu) */
/* Modified for VgaGames2 by Kurt Nienhaus */

#include <errno.h>
#include <ctype.h>

int fnpatt(const char *,const char *);

/* Note that this evalutes C many times. */
#define FOLD(c)  (isupper ((int)c) ? tolower ((int)c) : ((int)c))


int fnpatt(const char * pattern,const char * string) {
/* Match STRING against the filename pattern PATTERN, returning 1 if it matches, 0 if not. */
  register const char * p=pattern,* n=string;
  register char c;

  while ((c=*p++)!='\0') {
    c=FOLD(c);

    switch(c) {
      case '?':
        if (*n=='\0') {return(0);}
        break;

      case '\\':
        c=*p++;
        c=FOLD(c);
        if (FOLD(*n)!=c) {return(0);}
        break;

      case '*':
        for (c=*p++;c=='?' || c=='*';c=*p++,++n) {
          if (c=='?' && *n=='\0') {return(0);}
        }
        if (c=='\0') {return(1);}
        {char c1=(c=='\\')?*p:c;
         c1=FOLD(c1);
         for (--p;*n!='\0';++n) {
           if ((c=='[' || FOLD(*n)==c1) && (fnpatt(p,n)==1)) {return(1);}
         }
         return(0);
        }

      case '[':
        {register int not;
         /* Nonzero if the sense of the character class is inverted. */

         if (*n=='\0') {return(0);}
         not=(*p=='!' || *p=='^');
         if (not) {++p;}

         c=*p++;
         for (;;) {
           register char cstart=c,cend=c;
           if (c=='\\') {cstart=cend=*p++;}
           cstart=cend=FOLD(cstart);

           if (c=='\0') {return(0);}  /* [ (unterminated) loses. */

           c=*p++;
           c=FOLD(c);

           if (c=='-' && *p!=']') {
             cend=*p++;
             if (cend=='\\') {cend=*p++;}
             if (cend=='\0') {return(0);}
             cend=FOLD(cend);
             c=*p++;
           }

           if (FOLD(*n)>=cstart && FOLD(*n)<= cend) {goto matched;}

           if (c==']') {break;}
         }
         if (!not) {return(0);}
         break;

matched:;
         /* Skip the rest of the [...] that already matched.  */
         while (c!=']') {
           if (c=='\0') {return(0);}  /* [ (unterminated) loses. */
           c=*p++;
           if (c=='\\') {++p;}  /* XXX 1003.2d11 is unclear if this is right. */
           ++p;
         }
         if (not) {return(0);}
        }
        break;

      default:
        if (c!=FOLD(*n)) {return(0);}
    }
    ++n;
  }

  if (*n=='\0') {return(1);}
  return(0);
} /* Ende fnpatt */
