#ifndef NW_GLOB_H_
#define NW_GLOB_H_

#include "vgagames2.h"

#define NW_MAXPAKET   1152                  /* paket length */
#define NW_KEYSIZE    (1+KEYS_INDEX+3+2+1)  /* size for client-keystrokes */

extern char * memptr;
extern int memfd;

static void getlock(int,int);
static void freelock(int);


static void getlock(int cm,int pos) {
/* get a lock */
  struct flock lockinfo;
  memset(&lockinfo,0,sizeof(lockinfo));
  lockinfo.l_whence=SEEK_SET;
  lockinfo.l_start=pos;
  lockinfo.l_len=1;
  if (cm==0 && pos==0) {
    lockinfo.l_type=F_RDLCK;
  } else {
    lockinfo.l_type=F_WRLCK;
  }
  fcntl(memfd,F_SETLKW,&lockinfo);
} /* Ende getlock */


static void freelock(int pos) {
/* free a lock */
  struct flock lockinfo;
  memset(&lockinfo,0,sizeof(lockinfo));
  lockinfo.l_type=F_UNLCK;
  lockinfo.l_whence=SEEK_SET;
  lockinfo.l_start=pos;
  lockinfo.l_len=1;
  fcntl(memfd,F_SETLKW,&lockinfo);
} /* Ende freelock */

#endif /* NW_GLOB_H_ */
