#ifndef NW_IFI_GET_H
#define NW_IFI_GET_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <net/if.h>

struct ifi_info {
  char ifi_name[IFNAMSIZ];        /* interface name, null terminated */
  short ifi_flags;                /* IFF_xxx constants from <net/if.h> */
  short ifi_myflags;              /* our own IFI_xxx flags */
  struct sockaddr * ifi_addr;     /* primary address */
  struct sockaddr * ifi_brdaddr;  /* broadcast address */
  struct sockaddr * ifi_dstaddr;  /* destination address */
  struct sockaddr * ifi_netmask;  /* netmask */
  struct ifi_info * ifi_next;     /* next of these structures */
};

#define IFI_ALIAS 1  /* ifi_addr is an alias */

/* function prototypes */
extern struct ifi_info * get_ifi_info(int);
extern void free_ifi_info(struct ifi_info *);

#endif /* NW_IFI_GET_H */
