/* *****************************************************************
   VgaGames2
   Copyright (C) 2000-2007 Kurt Nienhaus <vgagames@vgagames.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
   ***************************************************************** */

/* write to and read from socket or pipe */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include "config.h"
#include "nw_rdwr.h"

ssize_t writen(int,const void *,size_t);
ssize_t readn(int,void *,size_t);
ssize_t readline(int,void *,size_t);


ssize_t writen(int fd,const void * vptr,size_t n) {
/* force number of bytes to write
** (errno=EAGAIN is ignored, until all data is written)
** 1.arg: socket descriptor
** 2.arg: buffer to write
** 3.arg: number of characters to write
** return: 3.arg or -1=error
*/
  size_t nleft;
  ssize_t nwritten;
  const char * ptr;
  struct sigaction sac,osac;
  if (vptr==NULL) {fprintf(stderr,"writen: buffer=NULL\n"); return((ssize_t)-1);}
  memset(&sac,0,sizeof(sac));
  sac.sa_handler=SIG_IGN;
  sigaction(SIGPIPE,&sac,&osac);
  ptr=vptr;
  nleft=n;
  while (nleft>0) {
    if ((nwritten=write(fd,ptr,nleft))<0) {
      if (errno==EAGAIN) {continue;}
      fprintf(stderr,"writen: %s\n",strerror(errno));
      sigaction(SIGPIPE,&osac,NULL);
      return(-1);
    }
    nleft-=nwritten;
    ptr+=nwritten;
  }
  sigaction(SIGPIPE,&osac,NULL);
  return(n);
} /* Ende writen */


ssize_t readn(int fd,void * vptr,size_t n) {
/* force reading n bytes from socket or pipe
** If nonblocking is set, errno=EAGAIN is only returned, if no data is present
** 1.arg: socket descriptor
** 2.arg: buffer
** 3.arg: number of bytes to read
** return: number of bytes in buffer (0 to 3.arg) or -1=error
*/
  size_t nleft;
  ssize_t nread;
  char * ptr;
  if (vptr==NULL) {fprintf(stderr,"readn: buffer=NULL\n"); return((ssize_t)-1);}
  ptr=(char *)vptr;
  nleft=n;
  while (nleft>0) {
    if ((nread=read(fd,ptr,nleft))<0) {
      if (errno==EAGAIN && nleft<n) {continue;}
      if (errno!=EAGAIN) {fprintf(stderr,"readn: %s\n",strerror(errno));}
      return((ssize_t)-1);
    } else if (nread==0) {break;}
    nleft-=nread;
    ptr+=nread;
  }
  return(n-nleft);
} /* Ende readn */


ssize_t readline(int fd,void * vptr,size_t maxlen) {
/* read line from socket or pipe
** If nonblocking is set, errno=EAGAIN is only returned, if no data is present
** 1.arg: socket descriptor
** 2.arg: buffer
** 3.arg: size of buffer
** return: number of bytes in buffer or -1=error
*/
  ssize_t n,rc;
  char c,* ptr;
  if (vptr==NULL) {fprintf(stderr,"readline: buffer=NULL\n"); return((ssize_t)-1);}
  ptr=(char *)vptr;
  for (n=1;n<(ssize_t)maxlen;n++) {
    if ((rc=read(fd,&c,1))==1) {
      *ptr++=c;
      if (c=='\n') {n++; break;}
    } else if (rc==0) {
      break;
    } else {
      if (errno==EAGAIN && n>1) {continue;}
      if (errno!=EAGAIN) {fprintf(stderr,"readline: %s\n",strerror(errno));}
      return((ssize_t)-1);
    }
  }
  *ptr='\0';
  return(n-1);
} /* Ende readline */
