#ifndef NW_SUPPORT_H
#define NW_SUPPORT_H

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include "config.h"


#ifndef HAVE_GETADDRINFO

struct addrinfo {
  int ai_flags;               /* AI_PASSIVE, AI_CANONNAME */
  int ai_family;              /* PF_xxx */
  int ai_socktype;            /* SOCK_xxx */
  int ai_protocol;            /* IPPROTO_xxx for IPv4_ and IPv6_ */
  size_t ai_addrlen;          /* length of ai_addr */
  char * ai_canonname;        /* canonical name for host */
  struct sockaddr * ai_addr;  /* binary address */
  struct addrinfo * ai_next;  /* next structure in linked list */
};
#define AI_PASSIVE      1  /* socket is intended for bind()+listen() */
#define AI_CANONNAME    2  /* return canonical name */

#ifndef AI_CLONE
# define AI_CLONE  4
#endif

#define EAI_ADDRFAMILY  1  /* address family for host not supported */
#define EAI_AGAIN       2  /* temporary failure in name resolution */
#define EAI_BADFLAGS    3  /* invalid value for ai_flags */
#define EAI_FAIL        4  /* non-recoverable failure in name resolution */
#define EAI_FAMILY      5  /* ai_family not supported */
#define EAI_MEMORY      6  /* memory allocation failure */
#define EAI_NODATA      7  /* no address associated with host */
#define EAI_NONAME      8  /* host nor service provided, or not known */
#define EAI_SERVICE     9  /* service not supported for ai_socktype */
#define EAI_SOCKTYPE   10  /* ai_socktype not supported */
#define EAI_SYSTEM     11  /* system error returned in errno */

#define NI_MAXHOST   1025  /* max hostname returned */
#define NI_MAXSERV     32  /* max service name returned */
#define NI_NOFQDN       1  /* do not return FQDN */
#define NI_NUMERICHOST  2  /* return numeric form of hostname */
#define NI_NAMEREQD     4  /* return error if hostname not found */
#define NI_NUMERICSERV  8  /* return numeric form of service name */
#define NI_DGRAM       16  /* datagram service for getservbyname() */

extern int getaddrinfo(const char *,const char *,const struct addrinfo *,struct addrinfo **);
extern void freeaddrinfo(struct addrinfo *);
extern char * gai_strerror(int);
extern int getnameinfo(const struct sockaddr *,socklen_t,char *,size_t,char *,size_t,int);
#endif /* HAVE_GETADDRINFO */


#ifndef HAVE_INETPTON
extern int inet_pton(int,const char *,void *);
#endif /* HAVE_INETPTON */

#ifndef HAVE_INETNTOP
extern const char * inet_ntop(int,const void *,char *,size_t);
#endif /* HAVE_INETNTOP */

#endif /* NW_SUPPORT_H */
