/* *****************************************************************
   VgaGames2
   Copyright (C) 2000-2007 Kurt Nienhaus <vgagames@vgagames.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
   ***************************************************************** */

/* get final link */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>

#ifndef S_ISLNK
  #define S_ISLNK(m)  (((m)&S_IFMT)==S_IFLNK)
#endif
#ifndef S_ISDIR
  #define S_ISDIR(m)  (((m)&S_IFMT)==S_IFDIR)
#endif

int read_link(const char *,char *,size_t,int);

#ifdef USE_MAIN
int main(int argc,char ** argv) {
/* Parameter: 1=Pfad, 2=(rel.Pfad/)Datei, 3=...
** sucht im Verz. 1.Arg und Unterverzeichnissen nach Dateien 2.-?.Arg
** wenn alle da, Ausgabe echtes Verzeichnis zum 2.Arg
*/
  struct stat sbuf;
  char pfad[1024],* ptr;
  int i1;
  DIR * edir;
  struct dirent * direntp;
  if (argc<3) {exit(1);}
  if (chdir(argv[1])<0) {exit(1);}
  for (i1=argc-1;i1>1;i1--) {
    snprintf(pfad,sizeof(pfad),"./%s",argv[i1]);
    if (stat(pfad,&sbuf)<0) {break;}
  }
  if (i1>1) {
    if ((edir=opendir("."))==NULL) {exit(1);}
    while ((direntp=readdir(edir))!=NULL) {
      if ((strcmp(direntp->d_name,"..")==0) || (strcmp(direntp->d_name,".")==0)) {continue;}
      if (stat(direntp->d_name,&sbuf)<0) {continue;}
      if (!S_ISDIR(sbuf.st_mode)) {continue;}
      for (i1=argc-1;i1>1;i1--) {
        snprintf(pfad,sizeof(pfad),"%s/%s",direntp->d_name,argv[i1]);
        if (stat(pfad,&sbuf)<0) {break;}
      }
      if (i1==1) {break;}
    }
    closedir(edir);
  }
  if (i1>1) {exit(1);}
  i1=read_link(pfad,pfad,sizeof(pfad),0);
  if (i1<0) {exit(1);}
  if ((ptr=strrchr(pfad,'/'))!=NULL) {*ptr='\0';} else {*pfad='\0';}
  printf("%s\n",pfad);
  fflush(stdout);
  exit(0);
} /* Ende main */
#endif /* USE_MAIN */


int read_link(const char * link,char * pfad,size_t pfadlen,int flag) {
/* give back real path of a link
** 1.arg: link
** 2.arg: address for real path
** 3.arg: sizeof 2.arg
** 4.arg: bitfield for flags
**        val 1: if not existing, give back last link instead of error
** return: >=0: OK (number of direct links)
**          -1: error (error message in 2.arg)
*/
  char cwdpfad[1024],buf[2][2048],* filep;
  int i1,idx,anz;
  struct stat sbuf;
  if ((pfad==NULL) || (pfadlen<1)) {return(-1);}
  if ((link==NULL) || (*link=='\0')) {
    snprintf(pfad,pfadlen,"read_link: symbolic link missing");
    return(-1);
  }
  if (getcwd(cwdpfad,sizeof(cwdpfad))==NULL) {  /* aktuellen Pfad sichern */
    snprintf(pfad,pfadlen,"read_link: getcwd: %s\n",strerror(errno));
    return(-1);
  }
  idx=0;
  snprintf(buf[idx],sizeof(buf[idx]),"%s",link);
  for (anz=0;;idx=!idx,anz++) {  /* Links folgen, solange vorhanden */
    if ((filep=strrchr(buf[idx],'/'))!=NULL) {  /* Verzeichnis wechseln */
      *filep++='\0';
      if (*buf[idx]=='\0') {i1=chdir("/");} else {i1=chdir(buf[idx]);}
      if (i1<0) {
        snprintf(pfad,pfadlen,"read_link: chdir to \"%s\": %s",buf[idx],strerror(errno));
        chdir(cwdpfad);
        return(-1);
      }
    } else {filep=buf[idx];}
    if (lstat(filep,&sbuf)<0) {
      if ((flag&1) && (anz>0)) {break;}
      snprintf(pfad,pfadlen,"read_link: lstat \"%s\": %s",filep,strerror(errno));
      chdir(cwdpfad);
      return(-1);
    }
    if (!S_ISLNK(sbuf.st_mode)) {break;}  /* kein Link mehr */
    if ((i1=readlink(filep,buf[!idx],sizeof(buf[!idx])-1))<0) {
      snprintf(pfad,pfadlen,"read_link: readlink \"%s\": %s",filep,strerror(errno));
      chdir(cwdpfad);
      return(-1);
    }
    buf[!idx][i1]='\0';
  }
  if (getcwd(buf[!idx],sizeof(buf[!idx]))==NULL) {  /* jetzigen Pfad erhalten */
    snprintf(pfad,pfadlen,"read_link: getcwd: %s\n",strerror(errno));
    return(-1);
  }
  snprintf(pfad,pfadlen,"%s/%s",strcmp(buf[!idx],"/")==0?"":buf[!idx],filep);
  chdir(cwdpfad);
  return(anz);
} /* Ende read_link */
