/* Include file for vgag-sound.h - ALSA 0.9 support */

#define ALSA_PCM_NEW_HW_PARAMS_API
#define ALSA_PCM_NEW_SW_PARAMS_API
#include <alsa/asoundlib.h>

/* definitions */
static const char * pcm_dev_alsa09="default";  /* ALSA09 device */
static snd_pcm_t * pcm_fd_alsa09=NULL;         /* ALSA09 device handle */
static const char * mix_dev_alsa09="default";  /* Mixer device */
static snd_mixer_t * mix_fd_alsa09=NULL;       /* Mixer device handle */
static snd_mixer_elem_t * mix_elem_alsa09[2];
static struct {
  int frame_bytes;      /* frame bytes */
  snd_pcm_uframes_t period_size;
  unsigned int periods;
  snd_pcm_uframes_t buffer_size;
} dev_cf_alsa09;


/* declarations */

static int _mixer_callback_alsa09(snd_mixer_t *,unsigned int,snd_mixer_elem_t *);
static int _conf_alsa09(struct sound_dev *,int,int);
static int _config_alsa09(struct sound_dev *,int,int);

int open_alsa09(struct sound_dev *,int,int);
void write_alsa09(struct sound_dev *,const unsigned char *,int);
void close_alsa09(struct sound_dev *);
int mixer_alsa09(struct sound_dev *,int);


/* internal functions */

static int _mixer_callback_alsa09(snd_mixer_t * mixer_fd,unsigned int mask,snd_mixer_elem_t * elem) {
  if (mask&SND_CTL_EVENT_MASK_ADD) {
    unsigned int idx=snd_mixer_selem_get_index(elem);
    if (idx==0) {  /* every first device element */
      if (strcmp(snd_mixer_selem_get_name(elem),"Master")==0) {
        mix_elem_alsa09[0]=elem;
        snd_mixer_selem_set_playback_volume_range(elem,0,100);
      } else if (strcmp(snd_mixer_selem_get_name(elem),"Headphone")==0) {
        if (mix_elem_alsa09[0]==NULL) {  /* if still no Master is found */
          mix_elem_alsa09[0]=elem;
          snd_mixer_selem_set_playback_volume_range(elem,0,100);
        }
      } else if (strcmp(snd_mixer_selem_get_name(elem),"PCM")==0) {
        mix_elem_alsa09[1]=elem;
        snd_mixer_selem_set_playback_volume_range(elem,0,100);
      }
    }
  }
  return(0);
} /* Ende _mixer_callback_alsa09 */


static int _conf_alsa09(struct sound_dev * sdptr,int srate,int channels) {
/* configure pcm device */
  unsigned int frg_anz;
  snd_pcm_uframes_t frg_sz;
  snd_pcm_uframes_t sw_val;
  int err,hw_dir=0;
  unsigned int rate,rrate;
  snd_pcm_hw_params_t * hw_par;
  snd_pcm_sw_params_t * sw_par;

  if (sdptr->frag_anz==0) {sdptr->frag_anz=fragment_anz;}
  if (sdptr->frag_size==0) {sdptr->frag_size=fragment_size;}
  frg_anz=sdptr->frag_anz;
  frg_sz=sdptr->frag_size;
  rate=(unsigned int)srate;
  /* reset device */
  /* if (snd_pcm_drop(pcm_fd_alsa09)>=0) {snd_pcm_prepare(pcm_fd_alsa09);} */

  /* +++ Hardware parameters +++ */
  snd_pcm_hw_params_alloca(&hw_par);
  snd_pcm_hw_params_any(pcm_fd_alsa09,hw_par);
  if ((err=snd_pcm_hw_params_set_access(pcm_fd_alsa09,hw_par,SND_PCM_ACCESS_RW_INTERLEAVED))<0) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_access: %s\n",snd_strerror(err));
    return(-1);
  }
  /* bits per sample */
#ifdef ENDIAN_IS_BIG
  if ((err=snd_pcm_hw_params_set_format(pcm_fd_alsa09,hw_par,SND_PCM_FORMAT_S16_BE))<0) {
#else
  if ((err=snd_pcm_hw_params_set_format(pcm_fd_alsa09,hw_par,SND_PCM_FORMAT_S16_LE))<0) {
#endif
    fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_format(16LE): %s\n",snd_strerror(err));
    if ((err=snd_pcm_hw_params_set_format(pcm_fd_alsa09,hw_par,SND_PCM_FORMAT_U8))<0) {
      fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_format(U8): %s\n",snd_strerror(err));
      return(-1);
    } else {sdptr->bitsamp=8;}
  } else {sdptr->bitsamp=16;}
  /* channels */
  if ((err=snd_pcm_hw_params_set_channels(pcm_fd_alsa09,hw_par,(unsigned int)channels))<0) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_channels(%d): %s\n",channels,snd_strerror(err));
    channels=(channels==2?1:2);
    if ((err=snd_pcm_hw_params_set_channels(pcm_fd_alsa09,hw_par,(unsigned int)channels))<0) {
      fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_channels(%d): %s\n",channels,snd_strerror(err));
      return(-1);
    } else {sdptr->channel=channels;}
  } else {sdptr->channel=channels;}
  /* sample rate */
  rrate=rate;
  if ((err=snd_pcm_hw_params_set_rate_near(pcm_fd_alsa09,hw_par,&rate,&hw_dir))<0) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_rate_near: %s\n",snd_strerror(err));
    return(-1);
  }
  if (((int)rate<(int)rrate-1000) || (rate>rrate+1000U)) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_rate_near: %d Hz requested, %d Hz got\n",rrate,rate);
    return(-1);
  }
  if ((err=snd_pcm_hw_params_set_periods_integer(pcm_fd_alsa09,hw_par))<0) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_periods_integer: %s\n",snd_strerror(err));
    return(-1);
  }
  sdptr->srate=srate;
  /* Fragments */
  if ((err=snd_pcm_hw_params_set_periods_near(pcm_fd_alsa09,hw_par,&frg_anz,&hw_dir))<0) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_periods_near: %s\n",snd_strerror(err));
    return(-1);
  }
#ifdef ENDIAN_IS_BIG
  dev_cf_alsa09.frame_bytes=snd_pcm_format_physical_width(sdptr->bitsamp==8?SND_PCM_FORMAT_U8:SND_PCM_FORMAT_S16_BE)*channels/8;
#else
  dev_cf_alsa09.frame_bytes=snd_pcm_format_physical_width(sdptr->bitsamp==8?SND_PCM_FORMAT_U8:SND_PCM_FORMAT_S16_LE)*channels/8;
#endif
  dev_cf_alsa09.periods=frg_anz;
  frg_sz/=dev_cf_alsa09.frame_bytes;
  if ((err=snd_pcm_hw_params_set_period_size_near(pcm_fd_alsa09,hw_par,&frg_sz,&hw_dir))<0) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params_set_period_size_near: %s\n",snd_strerror(err));
    return(-1);
  }
  dev_cf_alsa09.period_size=frg_sz;
  /* apply hw params to device */
  if ((err=snd_pcm_hw_params(pcm_fd_alsa09,hw_par))<0) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_hw_params: %s\n",snd_strerror(err));
    return(-1);
  }
  dev_cf_alsa09.buffer_size=dev_cf_alsa09.periods*dev_cf_alsa09.period_size;

  /* +++ Software parameters +++ */
  snd_pcm_sw_params_alloca(&sw_par);
  snd_pcm_sw_params_current(pcm_fd_alsa09,sw_par);
  sw_val=0;
  if ((err=snd_pcm_sw_params_set_start_threshold(pcm_fd_alsa09,sw_par,sw_val))<0) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_sw_params_set_start_threshold: %s\n",snd_strerror(err));
    return(-1);
  }
  /* apply sw params to device */
  if ((err=snd_pcm_sw_params(pcm_fd_alsa09,sw_par))<0) {
    fprintf(stderr,"  _conf_alsa09: snd_pcm_sw_params: %s\n",snd_strerror(err));
    return(-1);
  }
  return(0);
} /* Ende _conf_alsa09 */


static int _config_alsa09(struct sound_dev * sdptr,int srate,int channels) {
/* (re)configure pcm device */
  snd_pcm_sframes_t avail;
  memset(&dev_cf_alsa09,0,sizeof(dev_cf_alsa09));
  if (_conf_alsa09(sdptr,srate,channels)<0) {
    snd_pcm_close(pcm_fd_alsa09);
    snd_mixer_close(mix_fd_alsa09);
    return(-1);
  }
  avail=snd_pcm_avail_update(pcm_fd_alsa09);
  if ((avail<0) || ((snd_pcm_uframes_t)avail>dev_cf_alsa09.buffer_size)) {avail=dev_cf_alsa09.buffer_size;}
  sdptr->frag_size=dev_cf_alsa09.period_size*dev_cf_alsa09.frame_bytes;
  sdptr->frag_anz=(int)(avail/dev_cf_alsa09.period_size);
  fprintf(stderr,"  _config_alsa09: Fragments=%d, Fragstotal=%u, Fragment-Size=%d, Bytes=%ld\n",sdptr->frag_anz,dev_cf_alsa09.periods,sdptr->frag_size,(long)(avail*dev_cf_alsa09.frame_bytes));
  return(0);
} /* Ende _config_alsa09 */


/* functions */

int open_alsa09(struct sound_dev * sdptr,int srate,int channels) {
/* open device
** 2.arg=sample rate
** 3.arg=number of channels (1 or 2)
** return: 0=OK or -1=error
*/
  int err,retry;
  snd_pcm_stream_t stream=SND_PCM_STREAM_PLAYBACK;
  memset(&dev_cf_alsa09,0,sizeof(dev_cf_alsa09));

  /* +++ open pcm device +++ */
  for (retry=5;;retry--) {
    if (alarmtime==0) {
      if ((err=snd_pcm_open(&pcm_fd_alsa09,pcm_dev_alsa09,stream,SND_PCM_NONBLOCK))<0) {
        if ((retry>1) && (err==-EBUSY)) {sleep(1); continue;}
        fprintf(stderr,"  open_alsa09: snd_pcm_open \"%s\": %s\n",pcm_dev_alsa09,snd_strerror(err));
        return(-1);
      }
      if ((err=snd_pcm_nonblock(pcm_fd_alsa09,0))<0) {
        fprintf(stderr,"  open_alsa09: snd_pcm_nonblock \"%s\": %s\n",pcm_dev_alsa09,snd_strerror(err));
        snd_pcm_close(pcm_fd_alsa09);
        return(-1);
      }
    } else {
      alarm(alarmtime);
      if ((err=snd_pcm_open(&pcm_fd_alsa09,pcm_dev_alsa09,stream,0))<0) {
        alarm(0);
        if ((retry>1) && (err==-EBUSY)) {sleep(1); continue;}
        fprintf(stderr,"  open_alsa09: snd_pcm_open \"%s\": %s\n",pcm_dev_alsa09,snd_strerror(err));
        return(-1);
      }
      alarm(0);
    }
    break;
  }

  /* +++ Mixer +++ */
  if ((err=snd_mixer_open(&mix_fd_alsa09,0))<0) {
    fprintf(stderr,"  open_alsa09: snd_mixer_open: %s\n",snd_strerror(err));
    snd_pcm_close(pcm_fd_alsa09);
    return(-1);
  }

  if ((err=snd_mixer_attach(mix_fd_alsa09,mix_dev_alsa09))<0) {
    fprintf(stderr,"  open_alsa09: snd_mixer_attach \"%s\": %s\n",mix_dev_alsa09,snd_strerror(err));
    snd_pcm_close(pcm_fd_alsa09);
    snd_mixer_close(mix_fd_alsa09);
    return(-1);
  }
  if ((err=snd_mixer_selem_register(mix_fd_alsa09,NULL,NULL))<0) {
    fprintf(stderr,"  open_alsa09: snd_mixer_selem_register: %s\n",snd_strerror(err));
    snd_pcm_close(pcm_fd_alsa09);
    snd_mixer_close(mix_fd_alsa09);
    return(-1);
  }
  snd_mixer_set_callback(mix_fd_alsa09,_mixer_callback_alsa09);
  mix_elem_alsa09[0]=mix_elem_alsa09[1]=NULL;
  if ((err=snd_mixer_load(mix_fd_alsa09))<0) {
    fprintf(stderr,"  open_alsa09: snd_mixer_load: %s\n",snd_strerror(err));
    snd_pcm_close(pcm_fd_alsa09);
    snd_mixer_close(mix_fd_alsa09);
    return(-1);
  }
  if ((mix_elem_alsa09[0]==NULL) || (mix_elem_alsa09[1]==NULL)) {
    fprintf(stderr,"  open_alsa09: mixer volume not found.\n");
    snd_pcm_close(pcm_fd_alsa09);
    snd_mixer_close(mix_fd_alsa09);
    return(-1);
  }

  /* +++ configure pcm device and get fragment size +++ */
  return(_config_alsa09(sdptr,srate,channels));
} /* Ende open_alsa09 */


void write_alsa09(struct sound_dev * sdptr,const unsigned char * val,int size) {
/* write samples "val" of size "size" out to device */
  ssize_t erg;
  snd_pcm_uframes_t frames=size/dev_cf_alsa09.frame_bytes;
_wr_again:
  erg=snd_pcm_writei(pcm_fd_alsa09,val,frames);
  if ((erg==-EPIPE) && (snd_pcm_state(pcm_fd_alsa09)==SND_PCM_STATE_XRUN) \
  && ((erg=snd_pcm_prepare(pcm_fd_alsa09))==0)) {goto _wr_again;}
} /* Ende write_alsa09 */


void close_alsa09(struct sound_dev * sdptr) {
/* close device */
  snd_mixer_close(mix_fd_alsa09);
  mix_elem_alsa09[0]=mix_elem_alsa09[1]=NULL;
  if (snd_pcm_state(pcm_fd_alsa09)!=SND_PCM_STATE_OPEN) {snd_pcm_drop(pcm_fd_alsa09);}
  snd_pcm_close(pcm_fd_alsa09);
} /* Ende close_alsa09 */


int mixer_alsa09(struct sound_dev * sdptr,int volm) {
/* set main volume
** 2.arg: 0-100=set volume
**        -1=only get actual volume
**        -2=resume saved values
** return: <volume before (0-100)>: ok
**                              -1: error
*/
  static long lmrk[2]={-1L,-1L},rmrk[2]={-1L,-1L};
  int vvol,zvi;
  long lvol[2],rvol[2];
  int err,sw;

  for (zvi=0;zvi<2;zvi++) {
    if (!snd_mixer_selem_has_playback_volume(mix_elem_alsa09[zvi])) {
      fprintf(stderr,"mixer_alsa09: mixer volume not found.\n");
      return(-1);
    }
    /* read volume */
    if (snd_mixer_selem_has_playback_switch(mix_elem_alsa09[zvi])) {
      if ((err=snd_mixer_selem_get_playback_switch(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_LEFT,&sw))<0) {
        fprintf(stderr,"mixer_alsa09: snd_mixer_selem_get_playback_switch (%d left): %s\n",zvi,snd_strerror(err));
        return(-1);
      }
      if (sw) {
        if ((err=snd_mixer_selem_get_playback_volume(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_LEFT,&lvol[zvi]))<0) {
          fprintf(stderr,"mixer_alsa09: snd_mixer_selem_get_playback_volume (%d left): %s\n",zvi,snd_strerror(err));
          return(-1);
        }
      } else {lvol[zvi]=0L;}
    } else {
      if ((err=snd_mixer_selem_get_playback_volume(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_LEFT,&lvol[zvi]))<0) {
        fprintf(stderr,"mixer_alsa09: snd_mixer_selem_get_playback_volume (%d left): %s\n",zvi,snd_strerror(err));
        return(-1);
      }
    }
    if (snd_mixer_selem_is_playback_mono(mix_elem_alsa09[zvi])) {
      rvol[zvi]=lvol[zvi];
    } else {
      if (snd_mixer_selem_has_playback_switch(mix_elem_alsa09[zvi])) {
        if ((err=snd_mixer_selem_get_playback_switch(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_RIGHT,&sw))<0) {
          fprintf(stderr,"mixer_alsa09: snd_mixer_selem_get_playback_switch (%d right): %s\n",zvi,snd_strerror(err));
          return(-1);
        }
        if (sw) {
          if ((err=snd_mixer_selem_get_playback_volume(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_RIGHT,&rvol[zvi]))<0) {
            fprintf(stderr,"mixer_alsa09: snd_mixer_selem_get_playback_volume (%d right): %s\n",zvi,snd_strerror(err));
            return(-1);
          }
        } else {rvol[zvi]=0L;}
      } else {
        if ((err=snd_mixer_selem_get_playback_volume(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_RIGHT,&rvol[zvi]))<0) {
          fprintf(stderr,"mixer_alsa09: snd_mixer_selem_get_playback_volume (%d right): %s\n",zvi,snd_strerror(err));
          return(-1);
        }
      }
    }
  }
  if (lmrk[0]==-1L) {lmrk[0]=lvol[0]; lmrk[1]=lvol[1]; rmrk[0]=rvol[0]; rmrk[1]=rvol[1];}
  vvol=(int)(lvol[0]+rvol[0])/2;
  if (vvol>100) {vvol=100;}

  /* set volume */
  if (volm>=0) {
    if (volm>100) {volm=100;}
    lvol[0]=rvol[0]=lvol[1]=rvol[1]=(long)volm;
    lvol[1]=rvol[1]=100L;  /* make PCM always 100% */
  } else if (volm==-2) {
    lvol[0]=lmrk[0]; lvol[1]=lmrk[1];
    rvol[0]=rmrk[0]; rvol[1]=rmrk[1];
  }
  if ((volm>=0) || (volm==-2)) {
    for (zvi=0;zvi<2;zvi++) {
      if ((err=snd_mixer_selem_set_playback_volume(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_LEFT,lvol[zvi]))<0) {
        fprintf(stderr,"mixer_alsa09: snd_mixer_selem_set_playback_volume (%d left): %s\n",zvi,snd_strerror(err));
        return(-1);
      }
      if (snd_mixer_selem_is_playback_mono(mix_elem_alsa09[zvi])) {
        if (snd_mixer_selem_has_playback_switch(mix_elem_alsa09[zvi])) {
          if ((err=snd_mixer_selem_set_playback_switch(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_LEFT,(lvol[zvi]!=0L)))<0) {
            fprintf(stderr,"mixer_alsa09: snd_mixer_selem_set_playback_switch (%d left): %s\n",zvi,snd_strerror(err));
            return(-1);
          }
        }
      } else {
        if ((err=snd_mixer_selem_set_playback_volume(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_RIGHT,(rvol[zvi]))<0)) {
          fprintf(stderr,"mixer_alsa09: snd_mixer_selem_set_playback_volume (%d right): %s\n",zvi,snd_strerror(err));
          return(-1);
        }
        if (snd_mixer_selem_has_playback_switch(mix_elem_alsa09[zvi])) {
          if (snd_mixer_selem_has_playback_switch_joined(mix_elem_alsa09[zvi])) {
            if ((err=snd_mixer_selem_set_playback_switch(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_LEFT,(lvol[zvi]!=0L||rvol[zvi]!=0L)))<0) {
              fprintf(stderr,"mixer_alsa09: snd_mixer_selem_set_playback_switch (%d left+right): %s\n",zvi,snd_strerror(err));
              return(-1);
            }
          } else {
            if ((err=snd_mixer_selem_set_playback_switch(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_LEFT,(lvol[zvi]!=0L)))<0) {
              fprintf(stderr,"mixer_alsa09: snd_mixer_selem_set_playback_switch (%d left): %s\n",zvi,snd_strerror(err));
              return(-1);
            }
            if ((err=snd_mixer_selem_set_playback_switch(mix_elem_alsa09[zvi],SND_MIXER_SCHN_FRONT_LEFT,(rvol[zvi]!=0L)))<0) {
              fprintf(stderr,"mixer_alsa09: snd_mixer_selem_set_playback_switch (%d right): %s\n",zvi,snd_strerror(err));
              return(-1);
            }
          }
        }
      }
    }
  }
  return(vvol);
} /* Ende mixer_alsa09 */
