/* *****************************************************************
   VgaGames2
   Copyright (C) 2000-2007 Kurt Nienhaus <vgagames@vgagames.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
   ***************************************************************** */

/* system menu */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#include <ctype.h>
#include <errno.h>
#include "config.h"
#include "sysmenu.h"
#include "textformat.h"
#ifdef HAVE_X11
# include "video_x11.h"
#endif

extern void propfile_out(void);
extern int sound_frgs(int *,int *,int *,int *);

static int col[5];
static int noctrl=0;

void system_menu(int);
static void rahmen(void);
static int ctrl_c(int);
static void x11_menu(void);
static void x11_mode_menu(void);
static void mouse_menu(void);
static void sound_menu(void);
static void sound_volume(void);
static void lang_menu(void);


/* +++ functions +++ */

void system_menu(int flag) {
/* show main system menu */
  char clm[128],buf[128];
  int cli[10],ypos,fehler,i1,lbri;
  bitmap * wdbmp;
  if (block_sysmenu) {return;}
  wdbmp=vg_bitmap_duplicate(NULL);  /* save current window content */
  for (i1=0;i1<=9;i1++) {cli[i1]=0;}

  vg_sound_paus("ALL");
  vg_load_colormap(RGB256,clm,sizeof(clm));
  lbri=vg_brightness(0);
  col[0]=vg_color_index(CL_WHITE,50);
  col[1]=vg_color_index(CL_TURQUOISE,100);
  col[2]=vg_color_index(CL_BLUE,100);
  col[3]=vg_color_index(CL_YELLOW,100);
  col[4]=vg_color_index(CL_RED,100);

  vg_key_discard();

  if (flag) {
    noctrl=1;
    if (flag==1) {sound_volume();}
    else if (flag==2) {lang_menu();}

  } else {
    noctrl=0;
    fehler=0;
    while (1) {
      vg_bitmap_clear(NULL,RGB_BLACK);
      strlcpy(buf,"*** VgaGames2 ***",sizeof(buf));
      vg_draw_text(NULL,col[1],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,4,buf,NULL,RGB_FULL);
      rahmen();

      if (fehler) {
        if (++fehler%20==0) {fehler=1;}
        if (fehler<10) {
          strlcpy(buf,"ERROR",sizeof(buf));
          vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,20,buf,NULL,RGB_FULL);
        }
      }

      /* +++ print [1] +++ */
      ypos=40;
      cli[1]=1;
      strlcpy(buf,"[1]       X11 ...",sizeof(buf));
      vg_draw_text(NULL,col[cli[1]],5,ypos,buf,NULL,RGB_FULL);

      /* +++ print [2] +++ */
      ypos+=16;
      cli[1]=1;
      strlcpy(buf,"[2]       Mouse ...",sizeof(buf));
      vg_draw_text(NULL,col[cli[1]],5,ypos,buf,NULL,RGB_FULL);

      /* +++ print [3] +++ */
      ypos+=16;
      cli[1]=1;
      strlcpy(buf,"[3]       Sound ...",sizeof(buf));
      vg_draw_text(NULL,col[cli[1]],5,ypos,buf,NULL,RGB_FULL);

      /* +++ print [4] +++ */
      ypos+=16;
      cli[1]=1;
      strlcpy(buf,"[4]       Language ...",sizeof(buf));
      vg_draw_text(NULL,col[cli[1]],5,ypos,buf,NULL,RGB_FULL);

      /* +++ print [ESCAPE] / [CTRL]-[C] +++ */
      ypos=180;
      strlcpy(buf,"[ESCAPE]  Return      [CTRL]-[C]  Kill",sizeof(buf));
      vg_draw_text(NULL,col[1],5,ypos,buf,NULL,RGB_FULL);

      vg_window_flush();

      (void)vg_key_update();

      /* +++ [ESCAPE] pressed +++ */
      if (vg_key_pressed(KEYS_INDEX,SHORTKEY)) {break;}  /* Escape */

      /* +++ [CTRL]-[C] pressed +++ */
      fehler=ctrl_c(fehler);

      /* +++ [1] pressed +++ */
      if (vg_key_pressed(KEY_1,SHORTKEY)) {  /* [1]: X11 */
        x11_menu();
      }

      /* +++ [2] pressed +++ */
      if (vg_key_pressed(KEY_2,SHORTKEY)) {  /* [2]: Mouse */
        mouse_menu();
      }

      /* +++ [3] pressed +++ */
      if (vg_key_pressed(KEY_3,SHORTKEY)) {  /* [3]: Sound */
        sound_menu();
      }

      /* +++ [4] pressed +++ */
      if (vg_key_pressed(KEY_4,SHORTKEY)) {  /* [4]: Language */
        lang_menu();
      }

      vg_wait_time(70);
    }
  }
  vg_load_colormap(clm,NULL,0);
  vg_brightness(lbri);
  vg_bitmap_copyto(NULL,SC_WIDTH/2,SC_HEIGHT/2,wdbmp,0,0,0,0,RGB_FULL);  /* restore window */
  vg_window_flush();
  vg_sound_cont("ALL");
} /* Ende system_menu */


static void rahmen() {
/* draw frame */
  vg_draw_line(NULL,1,1,SC_WIDTH-2,1,col[1]);
  vg_draw_line(NULL,1,SC_HEIGHT-2,SC_WIDTH-2,SC_HEIGHT-2,col[1]);
  vg_draw_line(NULL,1,1,1,SC_HEIGHT-2,col[1]);
  vg_draw_line(NULL,SC_WIDTH-2,1,SC_WIDTH-2,SC_HEIGHT-2,col[1]);
  vg_draw_line(NULL,6,1,1,6,col[1]);
  vg_draw_line(NULL,SC_WIDTH-7,1,SC_WIDTH-2,6,col[1]);
  vg_draw_line(NULL,SC_WIDTH-7,SC_HEIGHT-2,SC_WIDTH-2,SC_HEIGHT-7,col[1]);
  vg_draw_line(NULL,6,SC_HEIGHT-2,1,SC_HEIGHT-7,col[1]);
  vg_draw_fillout(NULL,2,2,col[1]);
  vg_draw_fillout(NULL,2,SC_HEIGHT-3,col[1]);
  vg_draw_fillout(NULL,SC_WIDTH-3,2,col[1]);
  vg_draw_fillout(NULL,SC_WIDTH-3,SC_HEIGHT-3,col[1]);
} /* Ende rahmen */


static int ctrl_c(int fehler) {
/* [CTRL]-[C] pressed? */
  char buf[128];
  int ypos;
  if ((noctrl==0) && ((vg_key_pressed(KEY_LCTRL,LONGKEY)) || (vg_key_pressed(KEY_RCTRL,LONGKEY))) && (vg_key_pressed(KEY_C,SHORTKEY))) {
    /* Kill */
    vg_key_discard();
    fehler=1;
    while (1) {
      vg_bitmap_clear(NULL,RGB_BLACK);
      strlcpy(buf,"*** VgaGames2 ***",sizeof(buf));
      vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,4,buf,NULL,RGB_FULL);
      rahmen();
      ypos=SC_HEIGHT/2-vg_font_height(NULL)-20;
      if (++fehler%20==0) {fehler=1;}
      if (fehler<10) {
        strlcpy(buf,"Really kill the program???",sizeof(buf));
        vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,ypos,buf,NULL,RGB_FULL);
      }
      ypos+=32;
      strlcpy(buf,"[ESCAPE]  No         [CTRL]-[C]  Yes",sizeof(buf));
      vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,ypos,buf,NULL,RGB_FULL);
      vg_window_flush();
      (void)vg_key_update();
      if (((vg_key_pressed(KEY_LCTRL,LONGKEY)) || (vg_key_pressed(KEY_RCTRL,LONGKEY))) && (vg_key_pressed(KEY_C,SHORTKEY))) {
        fprintf(stderr,"system_menu: STRG-C has been pressed. Exiting.\n");
        vg_window_close();
        exit(1);
      }
      if (vg_key_pressed(KEYS_INDEX,SHORTKEY)) {break;}  /* Escape */
      vg_wait_time(70);
    }
    fehler=0;
  }
  return(fehler);
} /* Ende ctrl_c */


static void x11_menu() {
/* show X11 menu */
  char buf[128];
  int cli[10],ypos,fehler,i1,i2;
  struct w_mode wsave;
  for (i1=0;i1<=9;i1++) {cli[i1]=0;}

  vg_key_discard();
  fehler=0;
  while (1) {
    vg_bitmap_clear(NULL,RGB_BLACK);
    strlcpy(buf,"*** VgaGames2 - X11 ***",sizeof(buf));
    vg_draw_text(NULL,col[1],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,4,buf,NULL,RGB_FULL);
    rahmen();

    if (fehler) {
      if (++fehler%20==0) {fehler=1;}
      if (fehler<10) {
        strlcpy(buf,"ERROR",sizeof(buf));
        vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,20,buf,NULL,RGB_FULL);
      }
    }

    /* +++ print [1] +++ */
    ypos=40;
    if (window_mode.videolib==VIDEOLIB_X11) {cli[1]=1;}
    strlcpy(buf,"[1]       change window size",sizeof(buf));
    vg_draw_text(NULL,col[cli[1]],5,ypos,buf,NULL,RGB_FULL);
    ypos+=10;
    strlcpy(buf,"          (scaling factor: ",sizeof(buf));
    vg_draw_text(NULL,col[(cli[1]+1)*cli[1]],5,ypos,buf,NULL,RGB_FULL);
    i1=5+vg_font_width(NULL)*strlen(buf);
    i2=window_mode.vlb[window_mode.videolib].scale;
    i2=(i2==VGAWINDOW_1?1:(i2==VGAWINDOW_2?2:3));
    snprintf(buf,sizeof(buf),"%d",i2);
    vg_draw_text(NULL,col[(i2+1)*cli[1]],i1,ypos,buf,NULL,RGB_FULL);
    i1+=vg_font_width(NULL)*strlen(buf);
    strlcpy(buf,")",sizeof(buf));
    vg_draw_text(NULL,col[(cli[1]+1)*cli[1]],i1,ypos,buf,NULL,RGB_FULL);

    /* +++ print [2] +++ */
    ypos+=16;
    if ((window_mode.videolib==VIDEOLIB_X11) && (window_mode.vlb[window_mode.videolib].noswitch==0)) {cli[2]=1;}
    strlcpy(buf,"[2]       switch X11 mode",sizeof(buf));
    vg_draw_text(NULL,col[cli[2]],5,ypos,buf,NULL,RGB_FULL);
    ypos+=10;
    if (window_mode.vlb[window_mode.videolib].modenr==0) {
      strlcpy(buf,"          (automatic mode)",sizeof(buf));
    } else {
      snprintf(buf,sizeof(buf),"          (mode %d of %d: %dx%d)",window_mode.vlb[window_mode.videolib].modenr,window_mode.vlb[window_mode.videolib].modemax,window_mode.vlb[window_mode.videolib].modewidth,window_mode.vlb[window_mode.videolib].modeheight);
    }
    vg_draw_text(NULL,col[(cli[2]+1)*cli[2]],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [3] +++ */
    ypos+=16;
    if (window_mode.videolib==VIDEOLIB_X11) {cli[3]=1;}
    strlcpy(buf,"[3]       change to full/window",sizeof(buf));
    vg_draw_text(NULL,col[cli[3]],5,ypos,buf,NULL,RGB_FULL);
    ypos+=10;
    snprintf(buf,sizeof(buf),"          (%s)",window_mode.vlb[window_mode.videolib].full?"full":"window");
    vg_draw_text(NULL,col[(cli[3]+1)*cli[3]],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [4] +++ */
    ypos+=16;
    if (window_mode.videolib==VIDEOLIB_X11) {cli[4]=1;}
    strlcpy(buf,"[4]       (de)activate directdraw",sizeof(buf));
    vg_draw_text(NULL,col[cli[4]],5,ypos,buf,NULL,RGB_FULL);
    ypos+=10;
    snprintf(buf,sizeof(buf),"          (%s)",window_mode.vlb[window_mode.videolib].directdraw?"activated":"deactivated");
    vg_draw_text(NULL,col[(cli[4]+1)*cli[4]],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [ESCAPE] / [CTRL]-[C] +++ */
    ypos=180;
    strlcpy(buf,"[ESCAPE]  Return",sizeof(buf));
    if (noctrl==0) {strlcat(buf,"      [CTRL]-[C]  Kill",sizeof(buf));}
    vg_draw_text(NULL,col[1],5,ypos,buf,NULL,RGB_FULL);

    vg_window_flush();
    wsave=window_mode;

    (void)vg_key_update();

    /* +++ [ESCAPE] pressed +++ */
    if (vg_key_pressed(KEYS_INDEX,SHORTKEY)) {break;}  /* Escape */

    /* +++ [CTRL]-[C] pressed +++ */
    fehler=ctrl_c(fehler);

    /* +++ [1] pressed +++ */
    if ((cli[1]) && (vg_key_pressed(KEY_1,SHORTKEY))) {  /* [1]: scaling */
      fehler=0;
      switch(window_mode.vlb[window_mode.videolib].scale) {
        case VGAWINDOW_1:  window_mode.vlb[window_mode.videolib].scale=VGAWINDOW_3; break;
        case VGAWINDOW_2:  window_mode.vlb[window_mode.videolib].scale=VGAWINDOW_1; break;
        case VGAWINDOW_3:  window_mode.vlb[window_mode.videolib].scale=VGAWINDOW_2; break;
      }
      vg_window_close();
      if (vg_window_open(NULL,0,0)<0) {
        fehler=1;
        fprintf(stderr,"system_menu: error recalling vg_window_open (X11 scaling).\n");
        window_mode=wsave;
        if (vg_window_open(NULL,0,0)<0) {  /* fall back to previous mode */
          fprintf(stderr,"system_menu: error recalling vg_window_open for fallback. Exiting.\n");
          exit(1);
        }
      }
    }

    /* +++ [2] pressed +++ */
    if ((cli[2]) && (vg_key_pressed(KEY_2,SHORTKEY))) {  /* [2]: mode */
      fehler=0;
      x11_mode_menu();
      wsave=window_mode;
    }

    /* +++ [3] pressed +++ */
    if ((cli[3]) && (vg_key_pressed(KEY_3,SHORTKEY))) {  /* [3]: full/window */
      fehler=0;
      window_mode.vlb[window_mode.videolib].full=!window_mode.vlb[window_mode.videolib].full;
      vg_window_close();
      if (vg_window_open(NULL,0,0)<0) {
        fehler=1;
        fprintf(stderr,"system_menu: error recalling vg_window_open (X11 full/window).\n");
        window_mode=wsave;
        if (vg_window_open(NULL,0,0)<0) {  /* fall back to previous mode */
          fprintf(stderr,"system_menu: error recalling vg_window_open for fallback. Exiting.\n");
          exit(1);
        }
      }
    }

    /* +++ [4] pressed +++ */
    if ((cli[4]) && (vg_key_pressed(KEY_4,SHORTKEY))) {  /* [4]: directdraw */
      fehler=0;
      window_mode.vlb[window_mode.videolib].directdraw=!window_mode.vlb[window_mode.videolib].directdraw;
    }

    vg_wait_time(70);
  }
} /* Ende x11_menu */


static void x11_mode_menu() {
/* show X11 mode menu */
  char buf[128],** modes;
  int fehler,xpos,ypos,idnr,mdnr,mxnr,kcu,kcd;
  struct w_mode wsave;

  if ((modes=getmodes_x11())==NULL) {return;}
  for (mxnr=0;modes[mxnr]!=NULL;mxnr++) {;}
  if (mxnr<2) {return;}
  kcu=kcd=0;
  mdnr=window_mode.vlb[window_mode.videolib].modenr;

  vg_key_discard();
  fehler=0;
  while (1) {
    vg_bitmap_clear(NULL,RGB_BLACK);
    strlcpy(buf,"*** VgaGames2 - X11 modelines ***",sizeof(buf));
    vg_draw_text(NULL,col[1],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,4,buf,NULL,RGB_FULL);
    rahmen();

    if (fehler) {
      if (++fehler%20==0) {fehler=1;}
      if (fehler<10) {
        strlcpy(buf,"ERROR",sizeof(buf));
        vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,20,buf,NULL,RGB_FULL);
      }
    }

    idnr=window_mode.vlb[window_mode.videolib].scale;
    idnr=(idnr==VGAWINDOW_1?1:(idnr==VGAWINDOW_2?2:3));
    snprintf(buf,sizeof(buf),"scaling factor: %d",idnr);
    xpos=vg_font_width(NULL)*strlen(buf);
    vg_draw_text(NULL,col[idnr+1],(SC_WIDTH-xpos)/2,35,buf,NULL,RGB_FULL);

    /* +++ print modelines +++ */
    ypos=50;
    for (idnr=mdnr;idnr<mxnr;idnr++,ypos+=vg_font_height(NULL)+6) {
      if (ypos>150) {break;}
      snprintf(buf,sizeof(buf),"(%2d)",idnr);
      vg_draw_text(NULL,col[3],50,ypos,buf,NULL,RGB_FULL);
      xpos=vg_font_width(NULL)*strlen(modes[idnr]);
      if (idnr==mdnr) {
        vg_draw_box(NULL,(SC_WIDTH-xpos)/2,ypos,xpos,vg_font_height(NULL),col[3],1);
        vg_draw_text(NULL,RGB_DARK,(SC_WIDTH-xpos)/2,ypos,modes[idnr],NULL,RGB_TRANS);
      } else {vg_draw_text(NULL,col[3],(SC_WIDTH-xpos)/2,ypos,modes[idnr],NULL,RGB_FULL);}
    }

    /* +++ print keyinfo +++ */
    ypos=168;
    strlcpy(buf,"[Arrow Keys]=Move     [Return]=Select",sizeof(buf));
    vg_draw_text(NULL,col[1],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [ESCAPE] / [CTRL]-[C] +++ */
    ypos=180;
    strlcpy(buf,"[ESCAPE]  Return",sizeof(buf));
    if (noctrl==0) {strlcat(buf,"      [CTRL]-[C]  Kill",sizeof(buf));}
    vg_draw_text(NULL,col[1],5,ypos,buf,NULL,RGB_FULL);

    vg_window_flush();
    wsave=window_mode;

    (void)vg_key_update();

    /* +++ [ESCAPE] pressed +++ */
    if (vg_key_pressed(KEYS_INDEX,SHORTKEY)) {break;}  /* Escape */

    /* +++ [CTRL]-[C] pressed +++ */
    fehler=ctrl_c(fehler);

    /* +++ ArrowUp pressed +++ */
    if (vg_key_pressed(KEY_UCURS,LONGKEY)) {
      fehler=0;
      if (kcu==0 || kcu>=7) {
        if (--mdnr<0) {mdnr=0;}
      }
      if (kcu<7) {kcu++;}
    } else {kcu=0;}

    /* +++ ArrowDown pressed +++ */
    if (vg_key_pressed(KEY_DCURS,LONGKEY)) {
      fehler=0;
      if (kcd==0 || kcd>=7) {
        if (++mdnr>=mxnr) {mdnr=mxnr-1;}
      }
      if (kcd<7) {kcd++;}
    } else {kcd=0;}

    /* +++ [Return] pressed +++ */
    if (vg_key_pressed(KEY_ENTER,SHORTKEY)) {  /* [Return]: mode */
      fehler=0;
      window_mode.vlb[window_mode.videolib].scale=0;
      window_mode.vlb[window_mode.videolib].modenr=mdnr;
      vg_window_close();
      if (vg_window_open(NULL,0,0)<0) {
        fehler=1;
        fprintf(stderr,"system_menu: error recalling vg_window_open (X11 mode).\n");
        window_mode=wsave;
        if (vg_window_open(NULL,0,0)<0) {  /* fall back to previous mode */
          fprintf(stderr,"system_menu: error recalling vg_window_open for fallback. Exiting.\n");
          exit(1);
        }
      }
      if ((modes=getmodes_x11())==NULL) {return;}
      for (mxnr=0;modes[mxnr]!=NULL;mxnr++) {;}
      if (mxnr<2 || mdnr>=mxnr) {return;}
    }

    vg_wait_time(70);
  }
} /* Ende x11_mode_menu */


static void mouse_menu() {
/* show mouse menu */
  char buf[128];
  int cli[10],ypos,fehler,i1;
  for (i1=0;i1<=9;i1++) {cli[i1]=0;}

  vg_key_discard();
  fehler=0;
  while (1) {
    vg_bitmap_clear(NULL,RGB_BLACK);
    strlcpy(buf,"*** VgaGames2 - Mouse ***",sizeof(buf));
    vg_draw_text(NULL,col[1],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,4,buf,NULL,RGB_FULL);
    rahmen();

    if (fehler) {
      if (++fehler%20==0) {fehler=1;}
      if (fehler<10) {
        strlcpy(buf,"ERROR",sizeof(buf));
        vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,20,buf,NULL,RGB_FULL);
      }
    }

    /* +++ print [1] +++ */
    ypos=40;
    i1=0;
    if (vg_mouse_found()) {
      i1=vg_mouse_speed(0);
      if (i1) {
        cli[1]=1;
        snprintf(buf,sizeof(buf),"[1]       change speed (%s)",i1==1?"slow":(i1==2?"middle":"fast"));
      } else {
        strlcpy(buf,"[1]       cannot change speed",sizeof(buf));
      }
    } else {
      strlcpy(buf,"[1]       mouse not detected",sizeof(buf));
    }
    vg_draw_text(NULL,col[cli[1]],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [ESCAPE] / [CTRL]-[C] +++ */
    ypos=180;
    strlcpy(buf,"[ESCAPE]  Return",sizeof(buf));
    if (noctrl==0) {strlcat(buf,"      [CTRL]-[C]  Kill",sizeof(buf));}
    vg_draw_text(NULL,col[1],5,ypos,buf,NULL,RGB_FULL);

    /* +++ draw mouse +++ */
    if ((vg_mouse_found()) && (vg_mouse_x()>=0)) {  /* mouse found and inside window */
      vg_draw_box(NULL,vg_mouse_x()-1,vg_mouse_y()-1,3,3,RGB_WHITE,1);
      vg_draw_pixel(NULL,vg_mouse_x()-2,vg_mouse_y()-2,RGB_WHITE);
      vg_draw_pixel(NULL,vg_mouse_x()+2,vg_mouse_y()-2,RGB_WHITE);
      vg_draw_pixel(NULL,vg_mouse_x()-2,vg_mouse_y()+2,RGB_WHITE);
      vg_draw_pixel(NULL,vg_mouse_x()+2,vg_mouse_y()+2,RGB_WHITE);
    }

    vg_window_flush();

    (void)vg_key_update();

    /* +++ [ESCAPE] pressed +++ */
    if (vg_key_pressed(KEYS_INDEX,SHORTKEY)) {break;}  /* Escape */

    /* +++ [CTRL]-[C] pressed +++ */
    fehler=ctrl_c(fehler);

    /* +++ [1] pressed +++ */
    if ((cli[1]) && (vg_key_pressed(KEY_1,SHORTKEY))) {  /* [1]: change speed */
      fehler=0;
      if ((i1=vg_mouse_speed(0))>0) {
        if (++i1>3) {i1=1;}
        vg_mouse_speed(i1);
      }
    }

    vg_wait_time(70);
  }
} /* Ende mouse_menu */


static void sound_menu() {
/* show sound menu */
  char buf[128];
  int cli[10],ypos,fehler,i1,sndlauf,srate,channel,frg_anz,frg_sz,erg;
  for (i1=0;i1<=9;i1++) {cli[i1]=0;}

  srate=channel=frg_anz=frg_sz=0;
  sndlauf=sound_frgs(&srate,&channel,&frg_anz,&frg_sz);

  vg_key_discard();
  fehler=0;
  erg=0;
  while (1) {
    vg_bitmap_clear(NULL,RGB_BLACK);
    strlcpy(buf,"*** VgaGames2 - Sound ***",sizeof(buf));
    vg_draw_text(NULL,col[1],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,4,buf,NULL,RGB_FULL);
    rahmen();

    if (fehler) {
      if (++fehler%20==0) {fehler=1;}
      if (fehler<10) {
        strlcpy(buf,"ERROR",sizeof(buf));
        vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,20,buf,NULL,RGB_FULL);
      }
    }

    /* +++ print [1]-[2] +++ */
    ypos=40;
    if (sndlauf) {cli[1]=1;} else {cli[1]=0;}
    snprintf(buf,sizeof(buf),"[1]-[2]   fragments: %d",frg_anz);
    vg_draw_text(NULL,col[cli[1]],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [3]-[4] +++ */
    ypos+=16;
    if (sndlauf) {cli[2]=1;} else {cli[2]=0;}
    snprintf(buf,sizeof(buf),"[3]-[4]   fragment size: %d",frg_sz);
    vg_draw_text(NULL,col[cli[2]],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [5] +++ */
    ypos+=16;
    if (sndlauf) {cli[3]=1;} else {cli[3]=0;}
    snprintf(buf,sizeof(buf),"[5]       sample rate: %d",srate);
    vg_draw_text(NULL,col[cli[3]],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [6] +++ */
    ypos+=16;
    if (sndlauf) {cli[4]=1;} else {cli[4]=0;}
    snprintf(buf,sizeof(buf),"[6]       channels: %s",channel==1?"mono":(channel==2?"stereo":"0"));
    vg_draw_text(NULL,col[cli[4]],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [7] +++ */
    ypos+=16;
    ypos+=16;
    if (sndlauf) {cli[5]=1;} else {cli[5]=0;}
    snprintf(buf,sizeof(buf),"[7]       set volume ...");
    vg_draw_text(NULL,col[cli[5]],5,ypos,buf,NULL,RGB_FULL);

    /* +++ print [ESCAPE] / [CTRL]-[C] +++ */
    ypos=180;
    strlcpy(buf,"[ESCAPE]  Return",sizeof(buf));
    if (noctrl==0) {strlcat(buf,"      [CTRL]-[C]  Kill",sizeof(buf));}
    vg_draw_text(NULL,col[1],5,ypos,buf,NULL,RGB_FULL);

    vg_window_flush();

    (void)vg_key_update();

    /* +++ [ESCAPE] pressed +++ */
    if (vg_key_pressed(KEYS_INDEX,SHORTKEY)) {break;}  /* Escape */

    /* +++ [CTRL]-[C] pressed +++ */
    fehler=ctrl_c(fehler);

    /* +++ [1]-[2] pressed +++ */
    if ((cli[1]) && (vg_key_pressed(KEY_1,SHORTKEY))) {  /* [1]: fragments down */
      fehler=0;
      if (--frg_anz<2) {frg_anz=2;} else {erg=1;}
    }
    if ((cli[1]) && (vg_key_pressed(KEY_2,SHORTKEY))) {  /* [2]: fragments up */
      fehler=0;
      if (++frg_anz>16) {frg_anz=16;} else {erg=1;}
    }

    /* +++ [3]-[4] pressed +++ */
    if ((cli[2]) && (vg_key_pressed(KEY_3,SHORTKEY))) {  /* [3]: fragment size down */
      fehler=0;
      frg_sz/=2;
      if (frg_sz<128) {frg_sz=128;} else {erg=1;}
    }
    if ((cli[2]) && (vg_key_pressed(KEY_4,SHORTKEY))) {  /* [4]: fragment size up */
      fehler=0;
      frg_sz*=2;
      if (frg_sz>8192) {frg_sz=8192;} else {erg=1;}
    }

    /* +++ [5] pressed +++ */
    if ((cli[3]) && (vg_key_pressed(KEY_5,SHORTKEY))) {  /* [5]: sample rate */
      fehler=0;
      if (srate==11025) {srate=22050;}
      else if (srate==22050) {srate=44100;}
      else if (srate==44100) {srate=11025;}
      else {srate=22050;}
      erg=1;
    }

    /* +++ [6] pressed +++ */
    if ((cli[4]) && (vg_key_pressed(KEY_6,SHORTKEY))) {  /* [6]: channels */
      fehler=0;
      if (channel==1) {channel=2;} else {channel=1;}
      erg=1;
    }

    /* +++ [7] pressed +++ */
    if ((cli[5]) && (vg_key_pressed(KEY_7,SHORTKEY))) {  /* [7]: set volume */
      fehler=0;
      sound_volume();
    }

    vg_wait_time(70);
  }
  if ((erg) && (sndlauf) && (sound_frgs(&srate,&channel,&frg_anz,&frg_sz))) {
    sound_mode.frg_anz=frg_anz;
    sound_mode.frg_sz=frg_sz;
    sound_mode.srate=srate;
    sound_mode.channel=channel;
    propfile_out();
  }
} /* Ende sound_menu */


static void sound_volume() {
/* show sound volume menu */
  char buf[128];
  int cli[10],ypos,fehler,i1,volm[VOLUME_MAXNO+1],vpos;
  for (i1=0;i1<=9;i1++) {cli[i1]=0;}

  memset(volm,0,sizeof(volm));
  volm[0]=vg_sound_volm("0",-1);
  for (vpos=0;vpos<volume_name.anz;vpos++) {
    volm[vpos+1]=vg_sound_volm(volume_name.gname[vpos],-1);
  }

  vg_key_discard();
  fehler=0;
  while (1) {
    vg_bitmap_clear(NULL,RGB_BLACK);
    strlcpy(buf,"*** VgaGames2 - Sound volume ***",sizeof(buf));
    vg_draw_text(NULL,col[1],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,4,buf,NULL,RGB_FULL);
    rahmen();

    if (fehler) {
      if (++fehler%20==0) {fehler=1;}
      if (fehler<10) {
        strlcpy(buf,"ERROR",sizeof(buf));
        vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,20,buf,NULL,RGB_FULL);
      }
    }

    /* +++ print [1]-[2] +++ */
    ypos=40;
    if (volm[0]>=0) {cli[1]=1;} else {cli[1]=0;}
    snprintf(buf,sizeof(buf),"[1]-[2]   main volume: %d",volm[0]);
    vg_draw_text(NULL,col[cli[1]],5,ypos,buf,NULL,RGB_FULL);

    for (vpos=0;vpos<volume_name.anz;vpos++) {
      /* +++ print [3]-[4] ... [9]-[0] +++ */
      ypos+=16;
      if (volm[vpos+1]>=0) {cli[2+vpos]=1;} else {cli[2+vpos]=0;}
      snprintf(buf,sizeof(buf),"[%d]-[%d]   %s: %d",(vpos*2+3)%10,(vpos*2+4)%10,volume_name.vname[vpos],volm[vpos+1]);
      vg_draw_text(NULL,col[cli[2+vpos]],5,ypos,buf,NULL,RGB_FULL);
    }

    /* +++ print [ESCAPE] / [CTRL]-[C] +++ */
    ypos=180;
    strlcpy(buf,"[ESCAPE]  Return",sizeof(buf));
    if (noctrl==0) {strlcat(buf,"      [CTRL]-[C]  Kill",sizeof(buf));}
    vg_draw_text(NULL,col[1],5,ypos,buf,NULL,RGB_FULL);

    vg_window_flush();

    (void)vg_key_update();

    /* +++ [ESCAPE] pressed +++ */
    if (vg_key_pressed(KEYS_INDEX,SHORTKEY)) {break;}  /* Escape */

    /* +++ [CTRL]-[C] pressed +++ */
    fehler=ctrl_c(fehler);

    /* +++ [1]-[2] pressed +++ */
    if ((cli[1]) && (vg_key_pressed(KEY_1,LONGKEY))) {  /* [1]: main volume down */
      fehler=0;
      if (--volm[0]<0) {volm[0]=0;}
    }
    if ((cli[1]) && (vg_key_pressed(KEY_2,LONGKEY))) {  /* [2]: main volume up */
      fehler=0;
      if (++volm[0]>100) {volm[0]=100;}
    }

    if (volume_name.anz>0) {
      /* +++ [3]-[4] pressed +++ */
      if ((cli[2]) && (vg_key_pressed(KEY_3,LONGKEY))) {  /* [3]: volume down */
        fehler=0;
        if (--volm[1]<0) {volm[1]=0;}
      }
      if ((cli[2]) && (vg_key_pressed(KEY_4,LONGKEY))) {  /* [4]: volume up */
        fehler=0;
        if (++volm[1]>100) {volm[1]=100;}
      }
    }

    if (volume_name.anz>1) {
      /* +++ [5]-[6] pressed +++ */
      if ((cli[3]) && (vg_key_pressed(KEY_5,LONGKEY))) {  /* [5]: volume down */
        fehler=0;
        if (--volm[2]<0) {volm[2]=0;}
      }
      if ((cli[3]) && (vg_key_pressed(KEY_6,LONGKEY))) {  /* [6]: volume up */
        fehler=0;
        if (++volm[2]>100) {volm[2]=100;}
      }
    }

    if (volume_name.anz>2) {
      /* +++ [7]-[8] pressed +++ */
      if ((cli[4]) && (vg_key_pressed(KEY_7,LONGKEY))) {  /* [7]: volume down */
        fehler=0;
        if (--volm[3]<0) {volm[3]=0;}
      }
      if ((cli[4]) && (vg_key_pressed(KEY_8,LONGKEY))) {  /* [8]: volume up */
        fehler=0;
        if (++volm[3]>100) {volm[3]=100;}
      }
    }

    if (volume_name.anz>3) {
      /* +++ [9]-[0] pressed +++ */
      if ((cli[5]) && (vg_key_pressed(KEY_9,LONGKEY))) {  /* [9]: volume down */
        fehler=0;
        if (--volm[4]<0) {volm[4]=0;}
      }
      if ((cli[5]) && (vg_key_pressed(KEY_0,LONGKEY))) {  /* [0]: volume up */
        fehler=0;
        if (++volm[4]>100) {volm[4]=100;}
      }
    }

    vg_wait_time(70);
  }
  if (volm[0]>=0) {
    vg_sound_volm("0",volm[0]);
    sound_mode.vol[0]=volm[0];
    for (vpos=0;vpos<volume_name.anz;vpos++) {
      vg_sound_volm(volume_name.gname[vpos],volm[1+vpos]);
      sound_mode.vol[1+vpos]=volm[1+vpos];
    }
    propfile_out();
  }
} /* Ende sound_volume */


static void lang_menu() {
/* show language menu
** reads <CWDIR>/share/textformat.<language>
** where <language> is a lowercase language-code with 2 characters
*/
  char buf[128],lkz[4];
  int cli[10],ypos,fehler,i1;
  char langs[12][4];
  int llen,lpos;
  for (i1=0;i1<=9;i1++) {cli[i1]=0;}

  {DIR * dirp;
   struct dirent * direntp;
   llen=lpos=0;
   snprintf(buf,sizeof(buf),"%s/share",CWDIR);
   if ((dirp=opendir(buf))!=NULL) {
     while ((direntp=readdir(dirp))!=NULL) {
       if (strncmp(direntp->d_name,"textformat.",11)!=0) {continue;}
       if (strlen(direntp->d_name)!=13) {continue;}
       langs[llen][0]=tolower((int)direntp->d_name[11]);
       langs[llen][1]=tolower((int)direntp->d_name[12]);
       langs[llen][2]='\0';
       if (++llen==12) {break;}
     }
     closedir(dirp);
   }
   if (*lang_mode.lkz!='\0') {  /* selected language exists? */
     for (;lpos<llen;lpos++) {
       if (strcmp(lang_mode.lkz,langs[lpos])==0) {break;}
     }
     if (lpos==llen) {*lang_mode.lkz='\0';}
   } else {lpos=llen;}
   strlcpy(lkz,lang_mode.lkz,sizeof(lkz));
  }

  vg_key_discard();
  fehler=0;
  while (1) {
    vg_bitmap_clear(NULL,RGB_BLACK);
    strlcpy(buf,"*** VgaGames2 - Language ***",sizeof(buf));
    vg_draw_text(NULL,col[1],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,4,buf,NULL,RGB_FULL);
    rahmen();

    if (fehler) {
      if (++fehler%20==0) {fehler=1;}
      if (fehler<10) {
        strlcpy(buf,"ERROR",sizeof(buf));
        vg_draw_text(NULL,col[4],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,20,buf,NULL,RGB_FULL);
      }
    }

    /* +++ print [1] +++ */
    ypos=40;
    if (llen>0) {cli[1]=1;} else {cli[1]=0;}
    snprintf(buf,sizeof(buf),"[1]       language: %s",lpos==llen?"[default]":langs[lpos]);
    vg_draw_text(NULL,col[cli[1]],5,ypos,buf,NULL,RGB_FULL);

    /* draw usable language-codes */
    if (llen>0) {
      ypos+=32;
      strlcpy(buf,"Available languages",sizeof(buf));
      vg_draw_text(NULL,col[cli[1]],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,ypos,buf,NULL,RGB_FULL);
      ypos+=16;
      strlcpy(buf,"[",sizeof(buf));
      for (i1=0;i1<llen;i1++) {strlcat(buf,langs[i1],sizeof(buf)); strlcat(buf," ",sizeof(buf));}
      strlcat(buf,"]",sizeof(buf));
      vg_draw_text(NULL,col[cli[1]],(SC_WIDTH-vg_font_width(NULL)*strlen(buf))/2,ypos,buf,NULL,RGB_FULL);
    }

    /* +++ print [ESCAPE] / [CTRL]-[C] +++ */
    ypos=180;
    strlcpy(buf,"[ESCAPE]  Return",sizeof(buf));
    if (noctrl==0) {strlcat(buf,"      [CTRL]-[C]  Kill",sizeof(buf));}
    vg_draw_text(NULL,col[1],5,ypos,buf,NULL,RGB_FULL);

    vg_window_flush();

    (void)vg_key_update();

    /* +++ [ESCAPE] pressed +++ */
    if (vg_key_pressed(KEYS_INDEX,SHORTKEY)) {break;}  /* Escape */

    /* +++ [CTRL]-[C] pressed +++ */
    fehler=ctrl_c(fehler);

    /* +++ [1] pressed +++ */
    if ((cli[1]) && (vg_key_pressed(KEY_1,SHORTKEY))) {  /* [1]: change language */
      fehler=0;
      if (++lpos>llen) {lpos=0;}
    }

    vg_wait_time(70);
  }
  if (lpos<llen) {strlcpy(lang_mode.lkz,langs[lpos],sizeof(lang_mode.lkz));} else {*lang_mode.lkz='\0';}
  if (strcmp(lang_mode.lkz,lkz)!=0) {
    propfile_out();
    load_textformat(lang_mode.lkz);
  }
} /* Ende lang_menu */
