/*
    TiMidity++ -- MIDI to WAVE converter and player
    Copyright (C) 1999-2002 Masanao Izumo <mo@goice.co.jp>
    Copyright (C) 1995 Tuukka Toivonen <tt@cgs.fi>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    support.c - Define missing function
                Written by Masanao Izumo <mo@goice.co.jp>
*/

#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include "config.h"
#ifdef HAVE_SYS_SELECT_H
# include <sys/select.h>
#endif


int u_sleep(unsigned int usec)
{
    struct timeval tv;
    usec-=TIME_OF_SELECT*1000;
    if (usec<=0) {
      tv.tv_sec  = 0;
      tv.tv_usec = 1;
    } else {
      tv.tv_sec  = usec / 1000000;
      tv.tv_usec = usec % 1000000;
    }
    select(0, NULL, NULL, NULL, &tv);
    return(0);
}
