/* *****************************************************************
   VgaGames2
   Copyright (C) 2000-2007 Kurt Nienhaus <vgagames@vgagames.de>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
   ***************************************************************** */

/* UTF-8 text to ANSI */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

const char * utf8text(const char *);


const char * utf8text(const char * text) {
/* test for and convert UTF-8 (2 byte) text to ANSI text
** 1.arg: text
** return: 1.arg or static converted text
*/
  static char * ntxt=NULL;
  static int nlen=0;
  int tlen,rpos,wpos;
  if (text==NULL) {return(text);}
  if ((tlen=strlen(text))<1) {return(text);}
  if (ntxt==NULL) {
    if ((ntxt=malloc(sizeof(char)*(tlen+1)))==NULL) {return(text);}
    nlen=tlen+1;
  }
  if (tlen>=nlen) {
    if ((ntxt=realloc(ntxt,sizeof(char)*(tlen+1)))==NULL) {return(text);}
    nlen=tlen+1;
  }
  for (wpos=rpos=0;rpos<tlen;rpos++,wpos++) {
    if ((unsigned char)text[rpos]>=(unsigned char)0x80) {
      /* 0x00000080 - 0x000007FF: 110????? 10??????; using only 0x80 - 0xff */
      if (((unsigned char)text[rpos]!=(unsigned char)0xc2) && ((unsigned char)text[rpos]!=(unsigned char)0xc3)) {break;}
      if (((unsigned char)text[rpos+1]<(unsigned char)0x80) || ((unsigned char)text[rpos+1]>(unsigned char)0xbf)) {break;}
      ntxt[wpos]=(((text[rpos]&3)<<6)|(text[rpos+1]&0x3f));
      rpos++;
    } else {ntxt[wpos]=text[rpos];}
  }
  if (rpos<tlen) {return(text);}
  ntxt[wpos]='\0';
  return(ntxt);
} /* Ende utf8text */
