/* vgag-sound.h: support for various sound devices */

#include "config.h"

static int alarmtime=0;  /* opening blocking seconds or 0=nonblock */

/* Fragments (periods):
** should be 2 to 4 fragments, each 512 to 4096 bytes.
** The less the more "just in time" sound,
** but also the danger of "clicks" to be heard
*/
static int fragment_anz=3;      /* number of fragments */
static int fragment_size=1024;  /* fragment size */

struct sound_dev {  /* struct for functions for sound devices */
  int (*open_dev)(struct sound_dev *,int,int);
  void (*write_dev)(struct sound_dev *,const unsigned char *,int);
  void (*close_dev)(struct sound_dev *);
  int (*mixer_dev)(struct sound_dev *,int);
  int bitsamp,channel,srate,frag_anz,frag_size;
  const char * libname;
};


#ifdef HAVE_SOUND_ALSA09  /* ALSA 0.9 support */
  #include "sounddev_alsa09.h"
#endif
#ifdef HAVE_SOUND_OSS   /* OSS support */
  #include "sounddev_oss.h"
#endif
#ifdef HAVE_SOUND_SAUDIO  /* Sun audio support */
  #include "sounddev_saudio.h"
#endif


struct sound_dev s_dev[]={

#ifdef HAVE_SOUND_ALSA09  /* ALSA 0.9 support */
  {
   open_alsa09,
   write_alsa09,
   close_alsa09,
   mixer_alsa09,
   0,0,0,0,0,
   "ALSA09"
  },
#endif

#ifdef HAVE_SOUND_OSS   /* OSS support */
  {
   open_oss,
   write_oss,
   close_oss,
   mixer_oss,
   0,0,0,0,0,
   "OSS"
  },
#endif

#ifdef HAVE_SOUND_SAUDIO  /* Sun audio support */
  {
   open_saudio,
   write_saudio,
   close_saudio,
   mixer_saudio,
   0,0,0,0,0,
   "SUN-AUDIO"
  },
#endif

  /* last line! */
  {NULL,NULL,NULL,NULL,0,0,0,0,0,NULL}
};
