#ifndef VGAGAMES2_H_
#define VGAGAMES2_H_

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#include <sys/types.h>

#define SC_WIDTH 320
#define SC_HEIGHT 200

/* +++ vgagames-properties +++ */
extern struct w_mode {  /* properties of opened window */
  int isset;
  int videolib;
#define VIDEOLIB_X11     1
#define VIDEOLIB_SVGALIB 2
#define VIDEOLIB_VGL     3
#define VIDEOLIB_MAX     3  /* highest number of VIDEOLIB_* */
  struct {
    int scale;
#define VGAWINDOW_1          1
#define VGAWINDOW_2          2
#define VGAWINDOW_3          4
    int full;
#define VGAWINDOW_FULL       8
    int noswitch;
#define VGAWINDOW_NOSWITCH   16
    int directdraw;
#define VGAWINDOW_DIRECTDRAW 32
    /* internal use */
    int modenr,modemax;
    int modewidth,modeheight;
  } vlb[VIDEOLIB_MAX+1];
} window_mode;
extern struct s_mode {  /* properties of sound */
  int frg_anz;
  int frg_sz;
  int srate;
  int channel;
#define VOLUME_MAXNO 4
  int vol[VOLUME_MAXNO+1];
} sound_mode;
extern struct l_mode {  /* properties of language */
  char lkz[4];
} lang_mode;
#define INITVGA_NOFILE 1  /* don't read vgagames-properties file */


/* +++ key and mouse +++ */
#define KEYS_INDEX 70   /* number of keys defined */
#define KEY_0           0    /* 0 */
#define KEY_1           1    /* 1 */
#define KEY_2           2    /* 2 */
#define KEY_3           3    /* 3 */
#define KEY_4           4    /* 4 */
#define KEY_5           5    /* 5 */
#define KEY_6           6    /* 6 */
#define KEY_7           7    /* 7 */
#define KEY_8           8    /* 8 */
#define KEY_9           9    /* 9 */
#define KEY_A           10   /* A */
#define KEY_B           11   /* B */
#define KEY_C           12   /* C */
#define KEY_D           13   /* D */
#define KEY_E           14   /* E */
#define KEY_F           15   /* F */
#define KEY_G           16   /* G */
#define KEY_H           17   /* H */
#define KEY_I           18   /* I */
#define KEY_J           19   /* J */
#define KEY_K           20   /* K */
#define KEY_L           21   /* L */
#define KEY_M           22   /* M */
#define KEY_N           23   /* N */
#define KEY_O           24   /* O */
#define KEY_P           25   /* P */
#define KEY_Q           26   /* Q */
#define KEY_R           27   /* R */
#define KEY_S           28   /* S */
#define KEY_T           29   /* T */
#define KEY_U           30   /* U */
#define KEY_V           31   /* V */
#define KEY_W           32   /* W */
#define KEY_X           33   /* X */
#define KEY_Y           34   /* Y */
#define KEY_Z           35   /* Z */
#define KEY_KP_0        36   /* Keypad 0 */
#define KEY_KP_1        37   /* Keypad 1 */
#define KEY_KP_2        38   /* Keypad 2 */
#define KEY_KP_3        39   /* Keypad 3 */
#define KEY_KP_4        40   /* Keypad 4 */
#define KEY_KP_5        41   /* Keypad 5 */
#define KEY_KP_6        42   /* Keypad 6 */
#define KEY_KP_7        43   /* Keypad 7 */
#define KEY_KP_8        44   /* Keypad 8 */
#define KEY_KP_9        45   /* Keypad 9 */
#define KEY_TAB         46   /* Tabulator */
#define KEY_RCTRL       47   /* Right Control */
#define KEY_LCTRL       48   /* Left Control */
#define KEY_RALT        49   /* Right Alt */
#define KEY_LALT        50   /* Left Alt */
#define KEY_SPACE       51   /* Space */
#define KEY_ENTER       52   /* Return */
#define KEY_BSP         53   /* Backspace */
#define KEY_RCURS       54   /* Right Cursor */
#define KEY_LCURS       55   /* Left Cursor */
#define KEY_UCURS       56   /* Up Cursor */
#define KEY_DCURS       57   /* Down Cursor */
#define KEY_F1          58   /* F1 */
#define KEY_F2          59   /* F2 */
#define KEY_F3          60   /* F3 */
#define KEY_F4          61   /* F4 */
#define KEY_F5          62   /* F5 */
#define KEY_F6          63   /* F6 */
#define KEY_F7          64   /* F7 */
#define KEY_F8          65   /* F8 */
#define KEY_F9          66   /* F9 */
#define KEY_F10         67   /* F10 */
#define KEY_F11         68   /* F11 */
#define KEY_F12         69   /* F12 */
#define LONGKEY  1
#define SHORTKEY 2

#define MOUSE_LEFT   1
#define MOUSE_MIDDLE 2
#define MOUSE_RIGHT  3


/* +++ colors +++ */
#define COLOR_MAX   18  /* number of colors defined */
#define CL_RED             1
#define CL_REDORANGE       2
#define CL_ORANGE          3
#define CL_YELLOWORANGE    4
#define CL_YELLOW          5
#define CL_YELLOWGREEN     6
#define CL_GREEN           7
#define CL_TURQUOISEGREEN  8
#define CL_TURQUOISE       9
#define CL_TURQUOISEBLUE   10
#define CL_BLUE            11
#define CL_BLUEVIOLET      12
#define CL_VIOLET          13
#define CL_REDVIOLET       14
#define CL_PINK            15
#define CL_BROWN           16
#define CL_WHITE           17
#define CL_BLACK           18

#define RGB256  "rgb256.clm"
#define GREY256 "grey256.clm"


/* +++ bitmap +++ */
typedef struct {
  unsigned char * pxm;
  int width,height;
} bitmap;
#define RGB_FULL  1
#define RGB_TRANS 2
#define VGAFORMAT_VGA  1
#define VGAFORMAT_BMP  2
#define VGAFORMAT_PPM3 3
#define VGAFORMAT_PPM6 4
#define VG_RIGHT  1
#define VG_LEFT   2
#define VG_TOP    4
#define VG_BOTTOM 8
#define MIRROR_VT 1
#define MIRROR_HT 2
struct ovlap {  /* overlapping bitmaps */
  int hitside;  /* bitfield of VG_RIGHT, VG_LEFT, VG_TOP, VG_BOTTOM */
  int x_nohit,y_nohit;  /* last not overlapping position */
  int x_hit,y_hit;  /* first overlapping position */
  int step;  /* number of steps to overlapping */
};


/* +++ sprite +++ */
typedef struct {
  int max_elem;
  int curr_elem,curr_loop;
  struct {
    int anz_loop;
    bitmap * grf;
    char sname[16];
  } * elem;
} sprite;


/* +++ global variables +++ */
extern char _cwdir[512],_cwdir2[512];
extern int _rgbwhite,_rgbblack,_rgbdark;
extern int block_sysmenu;
#define RGB_WHITE _rgbwhite  /* white pixel */
#define RGB_BLACK _rgbblack  /* black pixel (transparent) */
#define RGB_DARK _rgbdark  /* second black pixel (not transparent) */
#define CWDIR _cwdir  /* game-directory */
extern struct vol_name {
  int anz;
  char vname[VOLUME_MAXNO][25];
  char gname[VOLUME_MAXNO][16];
} volume_name;
#define PROTO_TCP 1
#define PROTO_UDP 2
#define NWVAR_CHAR   1
#define NWVAR_UCHAR  2
#define NWVAR_SHORT  3
#define NWVAR_USHORT 4
#define NWVAR_INT    5
#define NWVAR_UINT   6
#define NW_MAXCLIENT  16    /* maximum number of network players */


/* +++ functions +++ */
/* vgagames2.c */
extern int vg_init_vgagames(const char *,int,const char *);
extern int vg_wait_time(int);
extern int vg_window_open(const char *,int,int);
extern void vg_window_flush(void);
extern void vg_window_close(void);
extern void vg_key_discard(void);
extern int vg_key_update(void);
extern int vg_key_pressed(int,int);
extern int vg_mouse_found(void);
extern int vg_mouse_x(void);
extern int vg_mouse_y(void);
extern int vg_mouse_pressed(int,int);
extern int vg_mouse_speed(int);
extern void vg_menu_volume(void);
extern void vg_menu_language(void);
extern int vg_timestamp(int *,int *,int *);
/* textformat.c */
extern const char * vg_get_textformat(const char *);
/* color.c */
extern int vg_load_colormap(const char *,char *,size_t);
extern int vg_color_index(int,int);
extern int vg_brightness(int);
/* font.c */
extern int vg_font_width(const char *);
extern int vg_font_height(const char *);
/* bitmap.c */
extern bitmap * vg_bitmap_createnew(int,int);
extern bitmap * vg_bitmap_createfromfile(const char *);
extern bitmap * vg_bitmap_createfromtext(int,int,int,int,const char *,const char *);
extern bitmap * vg_bitmap_duplicate(const bitmap *);
extern int vg_bitmap_width(const bitmap *);
extern int vg_bitmap_height(const bitmap *);
extern int vg_bitmap_getpixel(const bitmap *,int,int);
extern int vg_bitmap_save(const bitmap *,const char *,int);
extern void vg_bitmap_clear(bitmap *,int);
extern void vg_bitmap_copyto(bitmap *,int,int,const bitmap *,int,int,int,int,int);
extern bitmap * vg_bitmap_rotate(const bitmap *,int);
extern bitmap * vg_bitmap_zoom(const bitmap *,double,double);
extern bitmap * vg_bitmap_mirror(const bitmap *,int);
extern void vg_bitmap_free(bitmap *);
extern int vg_bitmap_overlap(struct ovlap *,const bitmap *,int,int,int,int,const bitmap *,int,int,int);
/* draw.c */
extern void vg_draw_text(bitmap *,int,int,int,const char *,const char *,int);
extern void vg_draw_pixel(bitmap *,int,int,int);
extern void vg_draw_line(bitmap *,int,int,int,int,int);
extern void vg_draw_box(bitmap *,int,int,int,int,int,int);
extern void vg_draw_circle(bitmap *,int,int,int,int,int);
extern void vg_draw_fillout(bitmap *,int,int,int);
/* sound.c */
extern int vg_sound_startserver(int,int,const char *);
extern void vg_sound_endserver(void);
extern void vg_sound_attach(const char *,const char *,int);
extern int vg_sound_play(const char *,int,int);
extern void vg_sound_paus(const char *);
extern void vg_sound_cont(const char *);
extern void vg_sound_pate(const char *);
extern void vg_sound_catb(const char *);
extern void vg_sound_stop(const char *,int);
extern void vg_sound_gclr(const char *);
extern void vg_sound_gadd(const char *,const char *);
extern void vg_sound_gdel(const char *,const char *);
extern int vg_sound_volm(const char *,int);
extern void vg_sound_volumename(const char *,const char *);
/* nw_server.c */
extern int vg_nw_setplayer(int,int);
extern int vg_nw_startserver(int,const char *,int,int,const char *,int);
/* nw_client.c */
extern int vg_nw_connect(int,const char *,const char *,const char *);
extern int vg_nw_waitforconnects(void);
extern void vg_nw_close(void);
extern int vg_nw_myplayer(void);
extern int vg_nw_maxplayer(void);
extern int vg_nw_virtualplayer(void);
extern int vg_nw_isalive(int);
extern int vg_nw_keypressed(int,int);
extern int vg_nw_mousepressed(int,int);
extern int vg_nw_mousex(void);
extern int vg_nw_mousey(void);
extern void vg_nw_setdead(int);
extern int vg_nw_setvar(int,int,const char *);
extern void * vg_nw_getvar(const char *,int);
extern int vg_nw_setcommon(int,int,const char *);
extern void * vg_nw_getcommon(const char *);
extern void vg_nw_dumppacket(void);
extern int vg_nw_recvkeys(int);
extern void vg_nw_senddata(int);
extern void vg_nw_sendcommon(void);
extern void vg_nw_sendinit(void);
extern int vg_nw_recvinit(void);
/* sprite */
extern sprite * vg_sprite_createnew(void);
extern sprite * vg_sprite_createfromfile(const char *);
extern int vg_sprite_add(sprite *,const bitmap *,int,const char *,int);
extern sprite * vg_sprite_duplicate(const sprite *);
extern sprite * vg_sprite_rotate(sprite *,int);
extern sprite * vg_sprite_zoom(sprite *,double,double);
extern sprite * vg_sprite_mirror(sprite *,int);
extern bitmap * vg_sprite_getnext(sprite *);
extern bitmap * vg_sprite_getcurrent(const sprite *);
extern void vg_sprite_reset(sprite *);
extern void vg_sprite_free(sprite *);
extern int vg_nw_dumpsprite(const sprite *);
extern void vg_nw_undumpsprite(sprite *,int);
/* film */
extern int vg_film_play(const char *,int (*)(int));
extern void vg_film_position(int *,int *,int *);


#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif /* VGAGAMES2_H_ */
