#ifndef MAIN_H_
#define MAIN_H_

#include <vgagames3.h>

/* object-id enumeration */
typedef enum {
  OID_NAME_MAZE,
  OID_NAME_PLAYER,
  OID_NAME_GHOST,
  OID_NAME_MINOTAUR,
  OID_NAME_MUSIC,
} OID_NAMES;

/* abstract key definitions for system-menu */
typedef enum {
  KEYDEF_GO_FORWARD,
  KEYDEF_GO_BACKWARD,
  KEYDEF_TURN_RIGHT,
  KEYDEF_TURN_LEFT,
  KEYDEF_TOGGLE_MAP,
  KEYDEF_TOGGLE_LAMP,
  KEYDEF_USE_ITEM,
} KEYDEFS;

/* subdirectory containing extra files */
#define FILES_DIR "files"

#define MAP_SHIFT  4

/* directions */
#define WAND_NORD    1
#define WAND_OST     2
#define WAND_SUED    4
#define WAND_WEST    8

/* additional bit-values for map: torch */
#define TORCH_SHIFT  (MAP_SHIFT * 1)
#define TORCH_NORD   (WAND_NORD << TORCH_SHIFT)
#define TORCH_OST    (WAND_OST  << TORCH_SHIFT)
#define TORCH_SUED   (WAND_SUED << TORCH_SHIFT)
#define TORCH_WEST   (WAND_WEST << TORCH_SHIFT)

/* additional bit-values for map: secret wall-portal */
#define PORTAL_SHIFT  (MAP_SHIFT * 2)
#define PORTAL_NORD   (WAND_NORD << PORTAL_SHIFT)
#define PORTAL_OST    (WAND_OST  << PORTAL_SHIFT)
#define PORTAL_SUED   (WAND_SUED << PORTAL_SHIFT)
#define PORTAL_WEST   (WAND_WEST << PORTAL_SHIFT)

/* additional bit-values for map: items */
#define ITEM_SHIFT     (MAP_SHIFT * 3)
#define ITEM_GARLIC    (1 << ITEM_SHIFT)
#define ITEM_VALERIAN  (2 << ITEM_SHIFT)
#define ITEM_JEWEL     (4 << ITEM_SHIFT)

/* random number from P1 to P2 inclusive */
#if 0
# define ZUFALL(P1, P2)  (P1 + (rand() % (P2 - P1 + 1)))
#else
# define ZUFALL(P1, P2)  VG3_nw_get_random((P1), (P2))
#endif


struct g_main {
  struct vg3_window *wstruct;   /* window struct */
  int brovdr;                   /* brightness */
  int winw, winh;               /* window size: width and height */
  struct vg3_sysmenu *sysm;     /* system-menu struct */
  char *sysm_string;            /* saved key-settings */
  struct vg3_keys *skeys;       /* keys-struct */
  struct vg3_multilang *mlang;  /* multilang-struct */
  struct vg3_ofunc *ofstruct;   /* object function main struct */
  struct vg3_nwclient *nwptr;   /* network struct */
  int clock, clockdelta;        /* clock timer, delta of clock */
  struct {                      /* common data for local player */
    unsigned int instanceid;      /* instance-ID of player to distinguish from remote playes */
    int bnr, x, y, dir;           /* player-bitmap-number, x-position, y-position and direction */
    int go, turn;                 /* whether going or turning */
    int gone;                     /* whether player found exit */
    int fear;                     /* player's fear */
    int dead;                     /* whether player is dead */
    int map;                      /* whether map is shown */
    int lamp;                     /* whether lamp is switched on */
    int garlic;                   /* amount of player's garlic smell */
    int jewel;                    /* whether player has jewel */
    char **mapvisited;            /* visited positions in map */
    const char *info;             /* info text */
  } ply;
  struct {                      /* data for maze */
    unsigned short **map;
    int wsize, hsize;
    int exit_x, exit_y, exit_dir;
  } maze;
};

#define WALK_MAX  256
struct walking_way {  /* way to walk in the maze */
  int anz, pos;
  struct {
    int x, y;
  } way[WALK_MAX];
};

struct obj_pos {  /* object in maze */
  int x, y, dir, prz;     /* position, direction and percent */
  struct vg3_image *img;  /* actual image */
  struct vg3_image_attributes attr;  /* actual image-attributes */
  int u_pg;               /* 1=player, 2=ghost/minotaur */
  union {
    struct {
      int lamp_ontime;           /* how many loops players lamp is switched on */
      int garlic;                /* whether player smells of garlic */
    } ply;
    struct {
      struct walking_way *wway;  /* walking way of ghost or minotaur */
      unsigned int follow_id;    /* instanceid of followed player, or 0 */
    } gh;
  } u;
};


/* main.c */
extern const char * get_oid_name(int);

/* misc.c */
extern void create_way(struct g_main *, struct walking_way *, int, int, int, int, int);
extern int draw_mazemap(struct g_main *);
extern int red_distance(struct g_main *, unsigned int);

/* save.c */
extern void settings_savetofile(struct g_main *);
extern void settings_readfromfile(struct g_main *, int);

#endif /* MAIN_H_ */
