#include "cellborder.h"
#include <cmath>
#include <tuple>

LineBorder::LineBorder(double x1, double y1, double x2, double y2)
    : x1_(x1), y1_(y1), x2_(x2), y2_(y2) {}

LineBorder::LineBorder(std::tuple<double, double, double, double> xy) {
  std::tie(x1_, y1_, x2_, y2_) = xy;
}

std::string LineBorder::SVGPrintString() const {
  return "<line x1=\"" + std::to_string(x1_ * 30) + "\" x2=\"" +
         std::to_string(x2_ * 30) + "\" y1=\"" + std::to_string(y1_ * 30) +
         "\" y2=\"" + std::to_string(y2_ * 30) +
         "\" stroke=\"black\" stroke-linecap=\"round\" stroke-width=\"3\"/>";
}
