#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>

#define WAND_NORD    1
#define WAND_OST     2
#define WAND_SUED    4
#define WAND_WEST    8

void makemaze(const char *);


static int getval(char *buf, const char *val) {
  char *pt1, *pt2;
  int ival;

  if (buf == NULL || val == NULL || *val == '\0') { fprintf(stderr, "getval: %s\n", strerror(EINVAL)); exit(1); }
  if ((pt1 = strstr(buf, val)) == NULL) { fprintf(stderr, "getval(%s): \"%s\" not found\n", buf, val); exit(1); }
  pt1 += strlen(val);
  if (*pt1 != '=') { fprintf(stderr, "getval(%s): \"%s\" corrupt\n", buf, val); exit(1); }
  pt1++;
  if (*pt1 != '"') { fprintf(stderr, "getval(%s): \"%s\" corrupt\n", buf, val); exit(1); }
  pt1++;
  if ((pt2 = strchr(pt1, '"')) == NULL) { fprintf(stderr, "getval(%s): \"%s\" corrupt\n", buf, val); exit(1); }
  if (pt2 == pt1) { fprintf(stderr, "getval(%s): \"%s\" corrupt\n", buf, val); exit(1); }
  ival = atoi(pt1) / 30;
  return ival;
}


void
makemaze(const char *svgmaze)
{
  char buf[512];
  char **feld;
  int wsize, hsize;
  int wpos, hpos;
  int x1, x2, y1, y2;
  size_t slen;
  const char *pt1, *pt2;

  if (svgmaze == NULL) { fprintf(stderr, "No maze-data\n"); exit(1); }

  wsize = hsize = 0;

  for (pt1 = svgmaze, pt2 = strchr(pt1, '\n'); ; pt1 = pt2 + 1, pt2 = strchr(pt1, '\n')) {
    if (pt2 == NULL) {
      pt2 = pt1 + strlen(pt1);
      if (pt1 == pt2) { break; }
    }
    snprintf(buf, sizeof(buf), "%.*s", (int)(pt2 - pt1), pt1);
    if (strstr(buf, "<svg ") != NULL) {
      wsize = getval(buf, "width") - 2;
      hsize = getval(buf, "height") - 2;
      break;
    }
    if (*pt2 == '\0') { break; }
  }
  if (wsize <= 0 || hsize <= 0) { fprintf(stderr, "Maze-size unknown\n"); exit(1); }

  feld = malloc(sizeof(char *) * hsize);
  if (feld == NULL) { fprintf(stderr, "malloc: %s\n", strerror(errno)); exit(1); }
  for (hpos = 0; hpos < hsize; hpos++) {
    feld[hpos] = malloc(sizeof(char) * wsize);
    if (feld[hpos] == NULL) { fprintf(stderr, "malloc: %s\n", strerror(errno)); exit(1); }
    memset(feld[hpos], 0, sizeof(char) * wsize);
  }

  for (pt1 = pt2 + 1, pt2 = strchr(pt1, '\n'); ; pt1 = pt2 + 1, pt2 = strchr(pt1, '\n')) {
    if (pt2 == NULL) {
      pt2 = pt1 + strlen(pt1);
      if (pt1 == pt2) { break; }
    }
    snprintf(buf, sizeof(buf), "%.*s", (int)(pt2 - pt1), pt1);
    slen = strlen(buf);
    if (slen > 0 && buf[slen - 1] == '\r') { slen--; }
    buf[slen] = '\0';
    if (strstr(buf, "<line ") != NULL) {
      x1 = getval(buf, "x1");
      x2 = getval(buf, "x2");
      y1 = getval(buf, "y1");
      y2 = getval(buf, "y2");
      if (x1 == x2 - 1 && y1 == y2) {
        if (y1 < hsize) { feld[hsize - y1 - 1][x1] |= WAND_SUED; }
        if (y1 > 0) { feld[hsize - y1][x1] |= WAND_NORD; }
      } else if (x1 == x2 && y1 == y2 - 1) {
        if (x1 < wsize) { feld[hsize - y1 - 1][x1] |= WAND_WEST; }
        if (x1 > 0) { feld[hsize - y1 - 1][x1 - 1] |= WAND_OST; }
      } else {
        fprintf(stderr, "Line corrupt: \"%s\"\n", buf);
        exit(1);
      }
    }
    if (*pt2 == '\0') { break; }
  }

  for (hpos = 0; hpos < hsize; hpos++) {
    for (wpos = 0; wpos < wsize; wpos++) {
      printf("%x", feld[hpos][wpos]);
    }
    printf("\n");
  }

  exit(0);
}
