#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"

void create_way(struct g_main *, struct walking_way *, int, int, int, int, int);
int draw_mazemap(struct g_main *);
int red_distance(struct g_main *, unsigned int);


/* create a walking way from xvon/yvon to xbis/ybis */
void
create_way(struct g_main *gmain, struct walking_way *wway, int walk_max, int xvon, int yvon, int xbis, int ybis)
{
  struct {
    int sdir, adir;
  } wegdir[WALK_MAX];
  int wdir;

  if (wway == NULL) { return; }
  wway->pos = -1;
  wway->anz = 0;
  if (gmain == NULL) { return; }

  if (walk_max < 1) { walk_max = 1; } else if (walk_max > WALK_MAX) { walk_max = WALK_MAX; }

  wway->pos = 0;
  wway->way[wway->pos].x = xvon;
  wway->way[wway->pos].y = yvon;
  wegdir[wway->pos].adir = wegdir[wway->pos].sdir = WAND_NORD;

  for (;;) {
    xvon = wway->way[wway->pos].x;
    yvon = wway->way[wway->pos].y;
    wdir = wegdir[wway->pos].adir;

    if (!(gmain->maze.map[yvon][xvon] & wdir)) {
      if (++wway->pos == walk_max) { wway->pos--; goto wdreh; }

      if (wdir == WAND_NORD) {
        yvon--;
      } else if (wdir == WAND_OST) {
        xvon++;
      } else if (wdir == WAND_SUED) {
        yvon++;
      } else if (wdir == WAND_WEST) {
        xvon--;
      }
      wway->way[wway->pos].x = xvon;
      wway->way[wway->pos].y = yvon;

      if (wdir == WAND_NORD) {
        wdir = WAND_SUED;
      } else if (wdir == WAND_OST) {
        wdir = WAND_WEST;
      } else if (wdir == WAND_SUED) {
        wdir = WAND_NORD;
      } else if (wdir == WAND_WEST) {
        wdir = WAND_OST;
      }
      wegdir[wway->pos].sdir = wegdir[wway->pos].adir = wdir;

      if (xvon == xbis && yvon == ybis) { break; }
    }

wdreh:
    if (wdir == WAND_NORD) {
      wdir = WAND_OST;
    } else if (wdir == WAND_OST) {
      wdir = WAND_SUED;
    } else if (wdir == WAND_SUED) {
      wdir = WAND_WEST;
    } else if (wdir == WAND_WEST) {
      wdir = WAND_NORD;
    }
    wegdir[wway->pos].adir = wdir;

    if (wegdir[wway->pos].adir == wegdir[wway->pos].sdir) {
      if (--wway->pos < 0) { break; }
      wdir = wegdir[wway->pos].adir;
      goto wdreh;
    }
  }

  wway->anz = wway->pos + 1;
  wway->pos = 0;
}


/* draw overview of maze with positions until key pressed */
int
draw_mazemap(struct g_main *gmain)
{
  int wandsize, gangsize;
  struct vg3_image *imgm, *hgbild;
  int wpos, hpos, colw, allmaze, showportal, goexit, dodraw;
  struct vg3_rect rect;
  struct vg3_image_attributes iattr;
  struct obj_pos opos_player;
  int col_gang = VG3_color_brightness(VGAG3_COLOR_WHITE, 50);
  int col_gang_visited = VG3_color_brightness(VGAG3_COLOR_YELLOW, 30);
  int col_wand = VGAG3_COLOR_BLACK;
  int col_portal = VGAG3_COLOR_BROWN;
  int col_exit = VG3_color_brightness(VGAG3_COLOR_GREEN, 50);
  int col_ghost = VGAG3_COLOR_VIOLET;
  int col_ghost_following = VGAG3_COLOR_PINK;
  int col_minotaur = VGAG3_COLOR_RED;
  int col_minotaur_following = VGAG3_COLOR_PINK;
  int col_player_local = VGAG3_COLOR_BLUE;
  int col_player_remote = VGAG3_COLOR_TURQUOISE;
  int col_item = VGAG3_COLOR_WHITE;

  if (gmain == NULL) { fprintf(stderr, "%s\n", strerror(EINVAL)); return 0; }
  if (gmain->maze.map == NULL || gmain->maze.wsize <= 0 || gmain->maze.hsize <= 0) {
    fprintf(stderr, "%s\n", strerror(EINVAL));
    return 0;
  }

  if (gmain->maze.hsize < 25 && gmain->maze.wsize < 25) {
    wandsize = 3;
    gangsize = 12;
  } else {
    wandsize = 2;
    gangsize = 8;
  }

  VGAG3_IMAGE_ATTRIBUTES_DEFAULT(&iattr);
  iattr.bright = 128;
  hgbild = VG3_image_clone(gmain->wstruct, NULL, &iattr, NULL, NULL);
  if (hgbild == NULL) { fprintf(stderr, "%s\n", VG3_error()); return 0; }

  allmaze = showportal = goexit = 0;
  if (gmain->ply.map == 2) { allmaze = 1; }
  if (gmain->ply.map == 3) { allmaze = showportal = 1; }
  if (gmain->ply.map == 4) { allmaze = showportal = goexit = 1; }

  VGAG3_IMAGE_ATTRIBUTES_DEFAULT(&iattr);

  imgm = VG3_image_create(gmain->wstruct,
           gmain->maze.wsize * (wandsize + gangsize + wandsize),
           gmain->maze.hsize * (wandsize + gangsize + wandsize));
  if (imgm == NULL) { fprintf(stderr, "%s\n", VG3_error()); return 0; }

  VG3_draw_clear(gmain->wstruct, imgm, col_gang);

  for (hpos = 0; hpos < gmain->maze.hsize; hpos++) {
    for (wpos = 0; wpos < gmain->maze.wsize; wpos++) {
      dodraw = !!allmaze;
      if (gmain->ply.mapvisited[hpos][wpos]) {
        rect.x = wpos * (wandsize + gangsize + wandsize);
        rect.w = wandsize + gangsize + wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize);
        rect.h = wandsize + gangsize + wandsize;
        VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, col_gang_visited);
        dodraw = 1;
      } else if (!allmaze) {
        if (gmain->maze.exit_y != hpos || gmain->maze.exit_x != wpos) { continue; }
      }
      if (gmain->maze.map[hpos][wpos] & WAND_NORD) {
        rect.x = wpos * (wandsize + gangsize + wandsize);
        rect.w = wandsize + gangsize + wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize);
        rect.h = wandsize;
        if (gmain->maze.exit_y == hpos && gmain->maze.exit_x == wpos && gmain->maze.exit_dir == WAND_NORD) {
          colw = col_exit;
        } else {
          colw = col_wand;
          if ((showportal || gmain->ply.mapvisited[hpos][wpos] & WAND_NORD)) {
            if (gmain->maze.map[hpos][wpos] & (WAND_NORD << PORTAL_SHIFT)) { colw = col_portal; }
          }
        }
        if (dodraw || colw == col_exit) { VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, colw); }
      }
      if (gmain->maze.map[hpos][wpos] & WAND_OST) {
        rect.x = wpos * (wandsize + gangsize + wandsize) + wandsize + gangsize;
        rect.w = wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize);
        rect.h = wandsize + gangsize + wandsize;
        if (gmain->maze.exit_y == hpos && gmain->maze.exit_x == wpos && gmain->maze.exit_dir == WAND_OST) {
          colw = col_exit;
        } else {
          colw = col_wand;
          if ((showportal || gmain->ply.mapvisited[hpos][wpos] & WAND_OST)) {
            if (gmain->maze.map[hpos][wpos] & (WAND_OST << PORTAL_SHIFT)) { colw = col_portal; }
          }
        }
        if (dodraw || colw == col_exit) { VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, colw); }
      }
      if (gmain->maze.map[hpos][wpos] & WAND_SUED) {
        rect.x = wpos * (wandsize + gangsize + wandsize);
        rect.w = wandsize + gangsize + wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize) + wandsize + gangsize;
        rect.h = wandsize;
        if (gmain->maze.exit_y == hpos && gmain->maze.exit_x == wpos && gmain->maze.exit_dir == WAND_SUED) {
          colw = col_exit;
        } else {
          colw = col_wand;
          if ((showportal || gmain->ply.mapvisited[hpos][wpos] & WAND_SUED)) {
            if (gmain->maze.map[hpos][wpos] & (WAND_SUED << PORTAL_SHIFT)) { colw = col_portal; }
          }
        }
        if (dodraw || colw == col_exit) { VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, colw); }
      }
      if (gmain->maze.map[hpos][wpos] & WAND_WEST) {
        rect.x = wpos * (wandsize + gangsize + wandsize);
        rect.w = wandsize;
        rect.y = hpos * (wandsize + gangsize + wandsize);
        rect.h = wandsize + gangsize + wandsize;
        if (gmain->maze.exit_y == hpos && gmain->maze.exit_x == wpos && gmain->maze.exit_dir == WAND_WEST) {
          colw = col_exit;
        } else {
          colw = col_wand;
          if ((showportal || gmain->ply.mapvisited[hpos][wpos] & WAND_WEST)) {
            if (gmain->maze.map[hpos][wpos] & (WAND_WEST << PORTAL_SHIFT)) { colw = col_portal; }
          }
        }
        if (dodraw || colw == col_exit) { VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, colw); }
      }
      if (gmain->maze.map[hpos][wpos] & (((1 << MAP_SHIFT) - 1) << ITEM_SHIFT)) {
        rect.x = wpos * (wandsize + gangsize + wandsize) + (wandsize + gangsize + wandsize) / 2;
        rect.w = 2;
        rect.y = hpos * (wandsize + gangsize + wandsize) + (wandsize + gangsize + wandsize) / 2;
        rect.h = 2;
        VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, col_item);
      }
    }
  }

  memset(&opos_player, 0, sizeof(opos_player));

  { const struct vg3_ofunc_objfunc *ofc;

    ofc = VG3_ofunc_get_objfunc(gmain->ofstruct, get_oid_name(OID_NAME_GHOST));
    if (ofc != NULL && ofc->f_data != NULL) {
      struct vg3_ofunc_objsnap *osnap;
      struct vg3_ofunc_object *objp;
      struct obj_pos opos;

      osnap = VG3_ofunc_objlist_newlist(gmain->ofstruct, get_oid_name(OID_NAME_GHOST));
      while ((objp = VG3_ofunc_objlist_nextlist(osnap)) != NULL) {
        opos.dir = 0;
        if (ofc->f_data(gmain, objp, &opos)) {
          if (allmaze || gmain->ply.mapvisited[opos.y][opos.x]) {
            rect.x = wandsize + gangsize / 4 + opos.x * (wandsize + gangsize + wandsize);
            rect.w = gangsize / 2;
            rect.y = wandsize + gangsize / 4 + opos.y * (wandsize + gangsize + wandsize);
            rect.h = gangsize / 2;
            VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, col_ghost);
            if (allmaze && opos.u.gh.follow_id) {
              int wypos;
              for (wypos = 1; wypos < opos.u.gh.wway->anz; wypos++) {
                rect.x = wandsize + gangsize / 3 + opos.u.gh.wway->way[wypos].x * (wandsize + gangsize + wandsize);
                rect.w = gangsize / 3;
                rect.y = wandsize + gangsize / 3 + opos.u.gh.wway->way[wypos].y * (wandsize + gangsize + wandsize);
                rect.h = gangsize / 3;
                VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, col_ghost_following);
              }
            }
          }
        }
      }
      VG3_ofunc_objlist_freelist(osnap);
    }

    ofc = VG3_ofunc_get_objfunc(gmain->ofstruct, get_oid_name(OID_NAME_MINOTAUR));
    if (ofc != NULL && ofc->f_data != NULL) {
      struct vg3_ofunc_object *objp;
      struct obj_pos opos;

      if (VG3_ofunc_objlist_find_obj(gmain->ofstruct, get_oid_name(OID_NAME_MINOTAUR), &objp) > 0) {
        opos.dir = 0;
        if (ofc->f_data(gmain, objp, &opos)) {
          if (allmaze || gmain->ply.mapvisited[opos.y][opos.x]) {
            rect.x = wandsize + gangsize / 4 + opos.x * (wandsize + gangsize + wandsize);
            rect.w = gangsize / 2;
            rect.y = wandsize + gangsize / 4 + opos.y * (wandsize + gangsize + wandsize);
            rect.h = gangsize / 2;
            VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, col_minotaur);
            if (allmaze && opos.u.gh.follow_id) {
              int wypos;
              for (wypos = 1; wypos < opos.u.gh.wway->anz; wypos++) {
                rect.x = wandsize + gangsize / 3 + opos.u.gh.wway->way[wypos].x * (wandsize + gangsize + wandsize);
                rect.w = gangsize / 3;
                rect.y = wandsize + gangsize / 3 + opos.u.gh.wway->way[wypos].y * (wandsize + gangsize + wandsize);
                rect.h = gangsize / 3;
                VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, col_minotaur_following);
              }
            }
          }
        }
      }
    }

    ofc = VG3_ofunc_get_objfunc(gmain->ofstruct, get_oid_name(OID_NAME_PLAYER));
    if (ofc != NULL && ofc->f_data != NULL) {
      struct vg3_ofunc_objsnap *osnap;
      struct vg3_ofunc_object *objp;
      struct obj_pos opos;

      osnap = VG3_ofunc_objlist_newlist(gmain->ofstruct, get_oid_name(OID_NAME_PLAYER));
      while ((objp = VG3_ofunc_objlist_nextlist(osnap)) != NULL) {
        opos.dir = 0;
        if (ofc->f_data(gmain, objp, &opos)) {
          if (allmaze || gmain->ply.mapvisited[opos.y][opos.x]) {
            rect.x = wandsize + gangsize / 4 + opos.x * (wandsize + gangsize + wandsize);
            rect.w = gangsize / 2;
            rect.y = wandsize + gangsize / 4 + opos.y * (wandsize + gangsize + wandsize);
            rect.h = gangsize / 2;
            VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, (objp->instanceid == gmain->ply.instanceid) ? col_player_local : col_player_remote);
          }
          if (objp->instanceid == gmain->ply.instanceid) { opos_player = opos; }
        }
      }
      if (opos_player.dir != 0) {
        if (allmaze || gmain->ply.mapvisited[opos_player.y][opos_player.x]) {
          rect.x = wandsize + gangsize / 4 + opos_player.x * (wandsize + gangsize + wandsize);
          rect.w = gangsize / 2;
          rect.y = wandsize + gangsize / 4 + opos_player.y * (wandsize + gangsize + wandsize);
          rect.h = gangsize / 2;
          VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, col_player_local);
        }
      }
      VG3_ofunc_objlist_freelist(osnap);
    }
  }

  if (goexit && opos_player.dir != 0) {
    struct walking_way wway;
    create_way(gmain, &wway, WALK_MAX, opos_player.x, opos_player.y, gmain->maze.exit_x, gmain->maze.exit_y);
    for (wway.pos = 1; wway.pos < wway.anz; wway.pos++) {
      rect.x = wandsize + gangsize * 3 / 8 + wway.way[wway.pos].x * (wandsize + gangsize + wandsize);
      rect.w = gangsize / 4;
      rect.y = wandsize + gangsize * 3 / 8 + wway.way[wway.pos].y * (wandsize + gangsize + wandsize);
      rect.h = gangsize / 4;
      VG3_draw_rect(gmain->wstruct, imgm, &rect, 1, col_player_local);
    }
  }

  if (opos_player.dir == WAND_OST) {
    iattr.rotate = 270;
  } else if (opos_player.dir == WAND_SUED) {
    iattr.rotate = 180;
  } else if (opos_player.dir == WAND_WEST) {
    iattr.rotate = 90;
  } else {
    iattr.rotate = 0;
  }

  VG3_draw_clear(gmain->wstruct, NULL, VGAG3_COLOR_BLACK);
  VG3_image_copy(gmain->wstruct, NULL, hgbild, gmain->winw / 2, gmain->winh / 2, NULL, 0);
  VG3_image_copy(gmain->wstruct, NULL, imgm, gmain->winw / 2, gmain->winh / 2, &iattr, 0);

  VG3_image_unload(gmain->wstruct, imgm);
  VG3_image_unload(gmain->wstruct, hgbild);

  return 0;
}


/* calculate enemy's maximal distance to player to have him follow */
int
red_distance(struct g_main *gmain, unsigned int instanceid)
{
  const int walk_red = 5;
  const struct vg3_ofunc_objfunc *ofc;
  struct vg3_ofunc_object *objp;
  struct obj_pos opos;

  if (gmain == NULL || instanceid == 0) { return walk_red; }

  objp = VG3_ofunc_objlist_isvalid(gmain->ofstruct, instanceid);
  if (objp == NULL) { return walk_red; }

  ofc = VG3_ofunc_get_objfunc(gmain->ofstruct, objp->oid);
  if (ofc == NULL || ofc->f_data == NULL) { return walk_red; }

  opos.dir = 0;
  if (!ofc->f_data(gmain, objp, &opos)) { return walk_red; }

  return walk_red + opos.u.ply.lamp_ontime / 20;
}
