#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"

void getofmgmt_ghost(struct vg3_ofunc_ofmgmt *);

static int f_activate(void *, struct vg3_ofunc *, va_list);
static void f_deactivate(void *, struct vg3_ofunc *);
static void f_run(void *, struct vg3_ofunc *);

static struct {
  int countdown;
} ghost_mgmt;


/* +++ get-function +++ */

/* fill out the passed structure for object-management-functions of this VgaGames3-object */
void
getofmgmt_ghost(struct vg3_ofunc_ofmgmt *ofm) {
  if (ofm == NULL) { return; }
  snprintf(ofm->oid, sizeof(ofm->oid), "%s", get_oid_name(OID_NAME_GHOST));
  ofm->f_activate = f_activate;
  ofm->f_deactivate = f_deactivate;
  ofm->f_run = f_run;
}


/* +++ object-management-functions +++ */

/* activate the managing of ghost-object
 * we need no parameters in ap
 */
static int
f_activate(void *vmain, struct vg3_ofunc *ofstruct, va_list ap)
{
  struct g_main *gmain = vmain;

  if (ofstruct == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return -1; }
  (void)gmain;

  /* no variadic parameters */
  (void)ap;

  ghost_mgmt.countdown = gmain->maze.wsize * gmain->maze.hsize / 2 + 100;

  return 0;
}


/* deactivate the managing of ghost-object */
static void
f_deactivate(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;

  if (ofstruct == NULL) { return; }
  (void)gmain;
}


/* execute managing of ghost-instances,
 * creating a new one, if not enough ghosts are active
 */
static void
f_run(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;
  int inst_ist, inst_soll;

  if (ofstruct == NULL) { return; }

  if (ghost_mgmt.countdown > 0) { ghost_mgmt.countdown--; }

  if (gmain->clock < 100) {
    inst_soll = (gmain->maze.wsize + gmain->maze.hsize) / 7 * (50 + gmain->clock / 2) / 100;
  } else {
    inst_soll = (gmain->maze.wsize + gmain->maze.hsize) / 7;
  }

  inst_ist = VG3_ofunc_objlist_find_obj(ofstruct, get_oid_name(OID_NAME_GHOST), NULL);

  if (inst_ist < inst_soll) {
    if (ghost_mgmt.countdown == 0) {  /* create ghost-instance */
      const struct vg3_ofunc_objfunc *ofc;
      ofc = VG3_ofunc_get_objfunc(ofstruct, get_oid_name(OID_NAME_GHOST));
      if (ofc == NULL) { return; }
      if (ofc->f_new(vmain, 0) == NULL) { fprintf(stderr, "%s\n", VG3_error()); return; }
      ghost_mgmt.countdown = -1;
    } else if (ghost_mgmt.countdown < 0) {
      ghost_mgmt.countdown = 200 + ZUFALL(10, 80);
    }
  }
}
