#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-player.h"
#include "obj-ghost.h"

void getoofc_player_ghost(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_player_ghost(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_PLAYER));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_GHOST));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_player *gobj_player;
  struct g_obj_ghost *gobj_ghost;
  struct vg3_ofunc_object *objp_player, *objp_ghost;
  int addfear;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* get private structs */
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_PLAYER)) == 0) {
    objp_player = objp1;
    objp_ghost = objp2;
  } else {
    objp_player = objp2;
    objp_ghost = objp1;
  }
  gobj_player = (struct g_obj_player *)objp_player->ostruct;
  gobj_ghost = (struct g_obj_ghost *)objp_ghost->ostruct;

  if (gobj_ghost->sprt_mom == gobj_ghost->sprtapp) { return VGAG3_COLL_RETURN_NOOP; }
  if (gobj_player->ghost_instanceid != 0) { return VGAG3_COLL_RETURN_NOOP; }
  if (gobj_player->garlic_smell > 0) { return VGAG3_COLL_RETURN_NOOP; }

  gobj_player->ghost_instanceid = objp_ghost->instanceid;
  addfear = 55 - (gmain->maze.wsize * gmain->maze.hsize / 40);
  if (addfear < 20) { addfear = 20; }
  gobj_player->fear += (addfear * gobj_player->fearmulti);
  gobj_player->map = 0;
  gobj_player->lamp_ontime = 0;
  gobj_ghost->horrorloop = HORRORLOOP_MAX;
  gobj_ghost->pos.prz = 0;
  if (objp_player->instanceid == gmain->ply.instanceid) {
    gobj_ghost->horrorzoom = 1;
    gmain->ply.map = gobj_player->map;
    gmain->ply.lamp = !!gobj_player->lamp_ontime;
    gmain->ply.fear = gobj_player->fear / gobj_player->fearmulti;
    VG3_audio_play(gmain->wstruct, gobj_ghost->sound.frighten, 0, 0);
  }
  gobj_ghost->sprt_mom = gobj_ghost->sprt[GHOST_SPRITE_HORROR];
  VG3_sprite_rewind(gobj_ghost->sprt_mom);

  return VGAG3_COLL_RETURN_HIT;
}
