#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-player.h"
#include "obj-minotaur.h"

void getoofc_player_minotaur(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_player_minotaur(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_PLAYER));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_MINOTAUR));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_player *gobj_player;
  struct g_obj_minotaur *gobj_minotaur;
  struct vg3_ofunc_object *objp_player, *objp_minotaur;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* get private structs */
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_PLAYER)) == 0) {
    objp_player = objp1;
    objp_minotaur = objp2;
  } else {
    objp_player = objp2;
    objp_minotaur = objp1;
  }
  gobj_player = (struct g_obj_player *)objp_player->ostruct;
  gobj_minotaur = (struct g_obj_minotaur *)objp_minotaur->ostruct;

  if (gobj_minotaur->sprt_mom == gobj_minotaur->sprtapp) { return VGAG3_COLL_RETURN_NOOP; }

  gobj_player->dead = 1;
  gobj_player->map = 0;
  gobj_player->lamp_ontime = 0;
  if (objp_player->instanceid == gmain->ply.instanceid) {
    gmain->ply.map = gobj_player->map;
    gmain->ply.lamp = !!gobj_player->lamp_ontime;
  }

  return VGAG3_COLL_RETURN_HIT;
}
