#ifndef MAIN_H_
#define MAIN_H_

#include <vgagames3.h>

/* object-id enumeration */
typedef enum {
  OID_NAME_GROUND = 1,
  OID_NAME_WALL,
  OID_NAME_TANK,
  OID_NAME_SHOT,
} OID_NAMES;

/* color of player enumeration */
typedef enum {
  PLAYER_COLOR_RED = 1,
  PLAYER_COLOR_YELLOW,
  PLAYER_COLOR_GREEN,
  PLAYER_COLOR_BLUE,
} PLAYER_COLORS;

/* abstract key definitions for system-menu */
typedef enum {
  KEYDEF_NOKEY = 0,    /* first entry */
  KEYDEF_GO_FORWARD,
  KEYDEF_GO_BACKWARD,
  KEYDEF_TURN_RIGHT,
  KEYDEF_TURN_LEFT,
  KEYDEF_FIRE,
  KEYDEF_MAXKEY        /* last entry */
} KEYDEFS;

/* subdirectory containing extra files */
#define FILES_DIR "files"

/* (maximal) number of players */
#define MAXPLAYER 4

/* only for debug purpose */
#undef SET_MARKER

/* game struct */
struct g_main {
  struct vg3_window *wstruct;   /* window struct */
  int winw, winh;               /* window size: width and height */
  struct vg3_multilang *mlang;  /* multi-language struct */
  struct vg3_sysmenu *sysm;     /* system-menu struct */
  struct vg3_nwclient *nwclnt;  /* network struct or NULL */
  struct vg3_rect hgrect;       /* position and size of ground-image */
  struct vg3_quadtree *qdtr;    /* Quadtree */
  struct vg3_ofunc *ofstruct;   /* object function main struct */
  char *sysm_string;            /* save-string for system-menu to save on disk */
  struct {                      /* struct with values of players */
    enum {                        /* player is of which kind */
      PLY_IS_NOTUSED = 0,           /* no player (skip it) */
      PLY_IS_LOCAL,                 /* local player with or without network */
      PLY_IS_REMOTE,                /* remote network player */
      PLY_IS_COMPUTER               /* player managed by computer */
    } ply;
    char name[32];                /* player name in network */
    int alive;                    /* is player alive? */
    int hits;                     /* number of hits against enemies */
    int color;                    /* player's color from PLAYER_COLORS */
    unsigned int instanceid;      /* instanceid of player's object-instance */
    int jid;                      /* local player's gamecontroller-/joystick-id or 0 = keyboard or -1 = all input-devices */
  } player[MAXPLAYER];
  int followplayer;               /* player number which follows window (usually local player) */
  int shownames;                  /* show player-names for some time */
};

/* individual struct for additional submenus */
struct my_menu {
  struct g_main *gmain;   /* pointer to game struct */
  char network_name[16];  /* player name in network */
};


/* main.c */
extern const char * get_oid_name(int);
extern const char * get_player_color(int);

/* keys.c */
extern void menu_insert_input(struct g_main *, int);
extern void nw_key(struct g_main *, int);
extern int event_update(struct g_main *, int *);
extern int key_ispressed(struct g_main *, int, int, int);

/* mymenu.c */
extern void mymenu_insert_help(struct g_main *);
extern void mymenu_insert_network(struct g_main *);
extern void mymenu_savetofile(struct g_main *);
extern void mymenu_readfromfile(struct g_main *, int);

/* plysel.c */
extern int player_select(struct g_main *, int *, int *);

/* misc.c */
extern void draw_lastline(struct g_main *, const char *, struct vg3_rect, int);
extern void show_winner(struct g_main *);
extern int show_demo(struct g_main *);

/* nw.c */
extern int network_connect(struct g_main *, int, const char *, int *);
extern int network_is_client_connected(struct g_main *, int);
extern void pause_game(struct g_main *);

#endif /* MAIN_H_ */
