#ifndef OBJ_TANK_H_
#define OBJ_TANK_H_

/* how to draw tank */
enum {
  TANK_IS_NORMAL = 0,
  TANK_IS_SHOOTING,
  TANK_IS_EXPLODING
};

struct g_obj_tank {
  int plnumber;       /* player number (1 to MAXPLAYER) */
  int shots_running;  /* how many own shots are released */
  int health_max;     /* health of tank at beginning */
  int health;         /* actual health of tank: if zero, tank is destroyed */
  int angle;          /* angle of direction tank wants to move */
  int immun;          /* how long tank cannot be destroyed (after being hit) */
  struct vg3_rect rect;   /* position of tank */
  struct vg3_rect crect;  /* collision rectangle of tank (a bit smaller than rect and constant) */
  int xdelta, ydelta;    /* moving tank in x- and y-direction */
  int xremainder, yremainder;  /* remainders of tank-moving */
  struct {            /* for tank-drawing */
    int sprt_no;        /* one of enum TANK_IS_* above */
    struct vg3_sprite *sprt[3];  /* sprites for each TANK_IS_*-enum */
    struct vg3_image *img;       /* actual image to draw (taken from actual sprite) */
    struct vg3_image_attributes iattr;  /* image attributes of actual image as in sprite defined */
  } i;
  struct vg3_image_attributes iattr;  /* image attributes of actual image and rotating with angle */
  struct {            /* computer player struct */
    int last_coll_status;  /* last status of VGAG3_COLL_RETURNS */
    int movingtype;        /* 0 = normal moving, >0 = special moving */
    int mvsteps;           /* steps before changing turning_angle */
    int turning_angle;     /* delta angle for new moving-direction */
    int shoot_rand;        /* upper bound of random number for adding to shoot_total, or <0: no adding */
    int shoot_total;       /* if it reaches shoot_number, shot is released */
    int shoot_number;      /* number, when shot is being released */
  } cp;
};

#endif /* OBJ_TANK_H_ */
