/* Copyright 2017-2020 Kurt Nienhaus
 *
 * This file is part of VgaGames3.
 * VgaGames3 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * VgaGames3 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with VgaGames3.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-shot.h"

void getoofc_shot_shot(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_shot_shot(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_SHOT));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_SHOT));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  const struct vg3_ofunc_objfunc *ofc1, *ofc2;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* call free-function of object (objp1) */
  ofc1 = VG3_ofunc_get_objfunc(gmain->ofstruct, objp1->oid);
  if (ofc1 != NULL && ofc1->f_free != NULL) { ofc1->f_free(gmain, objp1); }

  /* call individual explode-function of collision-object (objp2) */
  ofc2 = VG3_ofunc_get_objfunc(gmain->ofstruct, objp2->oid);
  if (ofc2 != NULL) {
    struct g_obj_shot_privfunc *privfunc = (struct g_obj_shot_privfunc *)ofc2->vpriv;
    if (privfunc != NULL && privfunc->f_explode != NULL) {
      privfunc->f_explode(gmain, objp2);
    } else if (ofc2->f_free != NULL) {
      ofc2->f_free(gmain, objp2);
    }
  }

  /* return DEAD-HIT of object (objp1) */
  return VGAG3_COLL_RETURN_DEAD;
}
