/* Copyright 2017-2020 Kurt Nienhaus
 *
 * This file is part of VgaGames3.
 * VgaGames3 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * VgaGames3 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with VgaGames3.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-shot.h"
#include "obj-wall.h"

void getoofc_shot_wall(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_shot_wall(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_SHOT));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_WALL));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_shot *gobj_shot;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* get private struct of OID_NAME_SHOT (we don't need private struct of OID_NAME_WALL) */
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_SHOT)) == 0) {
    gobj_shot = (struct g_obj_shot *)objp1->ostruct;
  } else {
    gobj_shot = (struct g_obj_shot *)objp2->ostruct;
  }

  /* correct moving-direction of shot according to collision-side of wall; there is no need to change collret->side */
  if (collret->side & (VGAG3_COLLSIDE_LEFT | VGAG3_COLLSIDE_RIGHT)) { gobj_shot->xdelta = -gobj_shot->xdelta; }
  if (collret->side & (VGAG3_COLLSIDE_TOP | VGAG3_COLLSIDE_BOTTOM)) { gobj_shot->ydelta = -gobj_shot->ydelta; }

  /* now shot is able to destroy own tank */
  gobj_shot->destroy_me = 1;

  return VGAG3_COLL_RETURN_CONTINUE;
}
