/* Copyright 2017-2020 Kurt Nienhaus
 *
 * This file is part of VgaGames3.
 * VgaGames3 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * VgaGames3 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with VgaGames3.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>

extern void getofc_tank(struct vg3_ofunc_objfunc *);
extern void getofc_ground(struct vg3_ofunc_objfunc *);
extern void getofc_shot(struct vg3_ofunc_objfunc *);
extern void getofc_wall(struct vg3_ofunc_objfunc *);
extern void getoofc_shot_tank(struct vg3_ofunc_objobjfunc *);
extern void getoofc_tank_tank(struct vg3_ofunc_objobjfunc *);
extern void getoofc_shot_shot(struct vg3_ofunc_objobjfunc *);
extern void getoofc_shot_wall(struct vg3_ofunc_objobjfunc *);
extern void getoofc_tank_wall(struct vg3_ofunc_objobjfunc *);

/* create new main-struct for object-functions */
struct vg3_ofunc * ofunc_new(void) {
  struct vg3_ofunc *ofstruct;
  struct vg3_ofunc_objfunc ofc;
  struct vg3_ofunc_objobjfunc oofc;
  struct vg3_ofunc_ofmgmt ofm;
  struct vg3_ofunc_okey okey;
  struct vg3_ofunc_ookey ookey;

  ofstruct = calloc(1, sizeof(*ofstruct));
  if (ofstruct == NULL) { return NULL; }

  ofstruct->hget = VG3_hash_new();
  ofstruct->hobj = VG3_hash_new();
  ofstruct->hiid = VG3_hash_new();
  ofstruct->hmgmt = VG3_hash_new();

  (void)ofc;
  (void)oofc;
  (void)ofm;
  (void)okey;
  (void)ookey;
  memset(&ofc, 0, sizeof(ofc));
  getofc_tank(&ofc);
  memset(&okey, 0, sizeof(okey));
  snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
  VG3_hash_set(ofstruct->hget, &okey, sizeof(okey), &ofc, sizeof(ofc));

  memset(&ofc, 0, sizeof(ofc));
  getofc_ground(&ofc);
  memset(&okey, 0, sizeof(okey));
  snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
  VG3_hash_set(ofstruct->hget, &okey, sizeof(okey), &ofc, sizeof(ofc));

  memset(&ofc, 0, sizeof(ofc));
  getofc_shot(&ofc);
  memset(&okey, 0, sizeof(okey));
  snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
  VG3_hash_set(ofstruct->hget, &okey, sizeof(okey), &ofc, sizeof(ofc));

  memset(&ofc, 0, sizeof(ofc));
  getofc_wall(&ofc);
  memset(&okey, 0, sizeof(okey));
  snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
  VG3_hash_set(ofstruct->hget, &okey, sizeof(okey), &ofc, sizeof(ofc));

  memset(&oofc, 0, sizeof(oofc));
  getoofc_shot_tank(&oofc);
  memset(&ookey, 0, sizeof(ookey));
  snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
  snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
  VG3_hash_set(ofstruct->hget, &ookey, sizeof(ookey), &oofc, sizeof(oofc));

  memset(&oofc, 0, sizeof(oofc));
  getoofc_tank_tank(&oofc);
  memset(&ookey, 0, sizeof(ookey));
  snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
  snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
  VG3_hash_set(ofstruct->hget, &ookey, sizeof(ookey), &oofc, sizeof(oofc));

  memset(&oofc, 0, sizeof(oofc));
  getoofc_shot_shot(&oofc);
  memset(&ookey, 0, sizeof(ookey));
  snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
  snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
  VG3_hash_set(ofstruct->hget, &ookey, sizeof(ookey), &oofc, sizeof(oofc));

  memset(&oofc, 0, sizeof(oofc));
  getoofc_shot_wall(&oofc);
  memset(&ookey, 0, sizeof(ookey));
  snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
  snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
  VG3_hash_set(ofstruct->hget, &ookey, sizeof(ookey), &oofc, sizeof(oofc));

  memset(&oofc, 0, sizeof(oofc));
  getoofc_tank_wall(&oofc);
  memset(&ookey, 0, sizeof(ookey));
  snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
  snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
  VG3_hash_set(ofstruct->hget, &ookey, sizeof(ookey), &oofc, sizeof(oofc));

  return ofstruct;
}
