#ifndef GAMESKEL_H_
#define GAMESKEL_H_

#include "menu_helper.h"


/* +++ define appearance +++ */

/* vgaversion (VGAG3_VGAVERSIONS) */
#define GAMESKEL_VGAVERSION  VGAG3_VGAVERSION_HIGH

/* scaling (VGAG3_WINSCALES) */
#define GAMESKEL_SCALING  VGAG3_WINSCALE_BESTSCALE

/* game menus (parameters for mh_init()) */
#define GAMESKEL_GAMEMENU_BGFILE    NULL
#define GAMESKEL_GAMEMENU_BGBRIGHT  0
#define GAMESKEL_GAMEMENU_MENUFC    VGAG3_COLOR_YELLOW
#define GAMESKEL_GAMEMENU_MENUBC    VG3_color_brightness(VGAG3_COLOR_BLUE, 20)
#define GAMESKEL_GAMEMENU_ONLEFT    1
#define GAMESKEL_GAMEMENU_TEXTFC    VGAG3_COLOR_YELLOW
#define GAMESKEL_GAMEMENU_TEXTBC    VGAG3_COLOR_TRANSPARENT

/* help menu (foreground- and background-color) */
#define GAMESKEL_HELPMENU_FC        VGAG3_COLOR_YELLOW
#define GAMESKEL_HELPMENU_BC        VG3_color_brightness(VGAG3_COLOR_ORANGE, 30)

/* system menu (color-parameters for VG3_sysmenu_new()) */
#define GAMESKEL_SYSMENU_FCNORMAL   VG3_color_brightness(VGAG3_COLOR_GREEN, 50)
#define GAMESKEL_SYSMENU_FCSELECT   VGAG3_COLOR_GREEN

/* main menu: selections for starting game
 * - 1 = local game: just "start game"
 * - 2 = local game: "start game" and "continue saved game"
 * - 3 = local or network game
 */
#define GAMESKEL_STARTING  1


/* +++ name of savefile +++ */
#define SVFILE_NAME "black-smurfs"


/* +++ loop-time waiting in msec +++ */
#define LOOP_TIME  70


/* +++ maximum number of players +++ */
#define MAX_PLAYERS 1


/* +++ object-ID enumeration +++ */
typedef enum {
  OID_NAME_PLAYFIELD,
  OID_NAME_SMURF,
  OID_NAME_DIRSEL,
  OID_NAME_MOUSESEL,
  OID_NAME_DICE,
  OID_NAME_ANIMATION,
  OID_NAME_MUSIC,
} OID_NAMES;


/* +++ abstract key definitions for system-menu +++ */
typedef enum {
  KEYDEF_GO_LEFT,
  KEYDEF_GO_RIGHT,
  KEYDEF_STOP,
} KEYDEFS;


/* +++ highest number dice can show +++ */
#define MAX_DICE_NUMBER 5


/* +++ animations +++ */
enum {
  ANIMATION_STARTING = 1,
  ANIMATION_SMURF_BLUE,
  ANIMATION_SMURF_BLACK,
  ANIMATION_SMURF_BLACKFLY,
  ANIMATION_BLACKSMURF_BYE,
  ANIMATION_ENDING  /* must be last entry */
};

/* +++ individual game struct +++ */

/* smurf-species */
enum { SPECIES_SMURF = 0, SPECIES_SMURF_BLACK, SPECIES_PAPASMURF, SPECIES_PAPASMURF_BLACK, SPECIES_FLY };

/* struct of actions */
enum {
  UART_ANIMATION = 1,  /* show animation
                        * parameters:
                        * - num (int): which one: from ANIMATION_* enum
                        */
  UART_DICE,           /* throw dice
                        * parameters: no
                        */
  UART_SELSMURF,       /* select blue smurf for moving
                        * parameters:
                        * - steps (int): number of steps to move
                        * - instanceid (unsigned int): instance-ID of selected smurf
                        */
  UART_MOVSMURF,       /* move smurf
                        * parameters:
                        * - steps (int): number of steps to move
                        * - instanceid (unsigned int): instance-ID
                        * - direction (int): direction to next step: 0 = default, 1 = left, 2 = right
                        */
  UART_MOUSESEL,       /* show mousepointer to select blue smurf
                        * parameters:
                        * - steps (int): number of steps to move
                        */
  UART_DIRSEL          /* show dialog to select direction to go: left or right
                        * parameters: no
                        */
};


#define PLAYFIELD_STEPS  33
struct g_game {
  struct {  /* playfield-map */
    int xpos, ypos;    /* position of center */
    int village;       /* is village? */
    int sarsaparille;  /* is located in sarsaparille field? */
    int river;         /* is located in the river? */
    int starting;      /* 0 = no starting-field, 1 = smurfs, 2 = papa-smurf, 3 = fly */
    int mirrordraw;    /* whether draw smurfs mirrored */
    int next[2];       /* next position(s) */
  } pfmap[PLAYFIELD_STEPS];
  struct vg3_actionstack *astck;  /* stack of actions */
  int smurf_total;     /* total number of smurfs */
  int smurf_pending;   /* number of smurfs waiting for activation */
  int smurf_saved;     /* number of saved smurfs */
  int showending;      /* whether show ending */
};


/* +++ external functions +++ */

/* gameskel.c */
extern const char * get_oid_name(int);
extern int gameskel_intro(struct vg3_window *);
extern void gameskel_setkeys(void *, struct vg3_sysmenu_submenu *, struct vg3_sysmenu_submenu *);
extern void gameskel_beforelevels(void *, struct menu_helper *);
extern void gameskel_levelstart(void *);
extern int gameskel_leveldone(void *);
extern void gameskel_levelstop(void *);
extern void gameskel_afterlevels(void *, struct menu_helper *);
extern void gameskel_settingsread(void *, FILE *);
extern void gameskel_settingssave(void *, FILE *);
extern void gameskel_settingsreset(void *);

extern void check_direction(void *, int, int, int, int *, int *);

#endif /* GAMESKEL_H_ */
