#ifndef MAIN_H_
#define MAIN_H_

/* +++ needs not to be changed +++ */

#include <vgagames3.h>
#include "gameskel.h"

/* exit-definition enumeration */
typedef enum {
  EXITDEF_NOOP = 0,        /* no exit, go on */
  EXITDEF_REDO_LEVEL,      /* restart actual game-level */
  EXITDEF_GOTO_MAINMENU,   /* goto main menu */
  EXITDEF_EXIT_OK,         /* exit game with no error */
  EXITDEF_EXIT_FAILURE,    /* exit game with errorcode = 1 */
} EXITDEFS;

/* subdirectory containing extra files */
#define FILES_DIR "files"

/* random number from P1 to P2 inclusive */
#if 1
# define ZUFALL(P1, P2)  (P1 + (rand() % (P2 - P1 + 1)))
#else
# define ZUFALL(P1, P2)  VG3_nw_get_random((P1), (P2))
#endif

/* main game struct */
struct g_main {
  struct vg3_window *wstruct;   /* window struct */
  int winw, winh;               /* window size: width and height */
  int clnr;                     /* network-client-number of local player (or 1 if no networking) */
  int exit;                     /* how to exit game-loop, value taken from EXITDEFS */
  struct vg3_sysmenu *sysm;     /* system-menu struct */
  char *sysm_string;            /* saved key-settings */
  struct vg3_keys *skeys;       /* keys-struct */
  struct vg3_multilang *mlang;  /* multilang-struct */
  struct vg3_quadtree *qdtr;    /* quadtree */
  struct vg3_ofunc *ofstruct;   /* object function main struct */
  struct vg3_nwclient *nwptr;   /* network struct */
  char nwserver[64];            /* name of network-server */
  int win_xdelta, win_ydelta;   /* horizontal and vertical adjustment of window-contents, see VG3_window_update() */
  int gamelevel;                /* game-level */
  struct g_game game;           /* individual game struct */
};


/* main.c */
extern void fade_out(struct vg3_window *, int, int);

/* save.c */
extern void settings_savetofile(struct g_main *);
extern void settings_readfromfile(struct g_main *, int);

#endif /* MAIN_H_ */
