#ifndef MENU_HELPER_H_
#define MENU_HELPER_H_

/* +++ needs not to be changed +++ */

#include <vgagames3.h>

#define MH_MAX_SELITEM  32

/* helper-struct for menus */
struct menu_helper {
  struct {  /* elements set by initialization */
    const char *files_dir;         /* pointer to (relative) path for files */
    struct vg3_window *wstruct;    /* window-struct */
    struct vg3_image *bgimage;     /* background image or NULL */
    int bgbright;                  /* brightness of background (0 - 255) */
    struct {                       /* menu */
      int fgcolor, bgcolor, onleft;  /* foreground-, background-color, orientation */
    } menu;
    struct {                       /* info-text */
      int fgcolor, bgcolor;          /* foreground-, background-color */
    } text;
  } init;

  struct {  /* selection elements */
    char *title;                   /* title of selection menu */
    char *item[MH_MAX_SELITEM];    /* text or path to image for each selection element */
  } sel;

  struct {  /* network info, will be set by .func.sel_nwserver() and used by .func.open_network() */
    int is_master;                 /* player, who starts network-server */
    char servername[64];           /* name of network-server */
  } nw;
  struct vg3_nwclient *nwptr;      /* network-struct, will be set by .func.open_network() */

  struct {  /* functions, set by initialization */
    int (*show_menu)(struct menu_helper *);
    int (*sel_nwserver)(struct menu_helper *);
    int (*open_network)(struct menu_helper *, int, int, struct vg3_keys *);
    int (*recv_nwdata)(struct menu_helper *, char *, size_t);
    int (*sel_imglist)(struct menu_helper *, int, int *, int, int);
  } func;
};


/* Initialization */
void mh_init(struct menu_helper *, const char *, struct vg3_window *, struct vg3_image *, int, int, int, int, int, int);

#endif /* MENU_HELPER_H_ */
