#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-dirsel.h"

void getofc_dirsel(struct vg3_ofunc_objfunc *);

static struct vg3_ofunc_object * f_new(void *, unsigned int, ...);
static void f_free(void *, struct vg3_ofunc_object *);
static void f_run(void *, struct vg3_ofunc_object *);
static void f_draw(void *, struct vg3_ofunc_object *);


/* +++ get-function +++ */

void
getofc_dirsel(struct vg3_ofunc_objfunc *ofc)
{
  if (ofc == NULL) { return; }

  snprintf(ofc->oid, sizeof(ofc->oid), "%s", get_oid_name(OID_NAME_DIRSEL));
  ofc->f_new = f_new;
  ofc->f_free = f_free;
  ofc->f_run = f_run;
  ofc->f_draw = f_draw;
}


/* +++ object-instance-functions +++ */

/* new-function
 * variable parameter: none
 */
static struct vg3_ofunc_object *
f_new(void *vmain, unsigned int iparent, ...)
{
  struct g_main *gmain = vmain;
  struct vg3_ofunc_object *objp;
  struct g_obj_dirsel *gobj;
  va_list ap;

  if (gmain == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return NULL; }

  /* get arguments */
  va_start(ap, iparent);
  va_end(ap);

  /* create private struct for object */
  gobj = calloc(1, sizeof(*gobj));
  if (gobj == NULL) { VG3_seterror(ENOMEM, strerror(errno)); return NULL; }

  gobj->img = VG3_image_load(gmain->wstruct, FILES_DIR "/bmp/dirsel/dirsel.bmp", 1);
  if (gobj->img == NULL) { return NULL; }

  gobj->img_shd = VG3_image_load(gmain->wstruct, FILES_DIR "/bmp/dirsel/dirsel-shadow.bmp", 1);
  if (gobj->img_shd == NULL) { return NULL; }

  /* create and fill dirsel-instance */
  objp = calloc(1, sizeof(*objp));
  if (objp == NULL) { VG3_seterror(ENOMEM, strerror(errno)); return NULL; }
  snprintf(objp->oid, sizeof(objp->oid), "%s", get_oid_name(OID_NAME_DIRSEL));
  objp->drawlevel = 4;
  objp->instanceid = 0;  /* will be set in VG3_ofunc_objlist_insert() */
  objp->ostruct = gobj;

  /* insert dirsel-instance into list of object-instances */
  VG3_ofunc_objlist_insert(gmain->ofstruct, objp);

  return objp;
}


/* free-function */
static void
f_free(void *vmain, struct vg3_ofunc_object *objp)
{
  struct g_main *gmain = vmain;
  struct g_obj_dirsel *gobj;

  if (gmain == NULL || objp == NULL) { return; }

  gobj = (struct g_obj_dirsel *)objp->ostruct;

  /* remove dirsel-instance from list of object-instances */
  VG3_ofunc_objlist_remove(gmain->ofstruct, objp);

  /* free dirsel-instance */
  if (gobj->img != NULL) { VG3_image_unload(gmain->wstruct, gobj->img); }
  if (gobj->img_shd != NULL) { VG3_image_unload(gmain->wstruct, gobj->img_shd); }
  free(gobj);
  free(objp);
}


/* run-function */
static void
f_run(void *vmain, struct vg3_ofunc_object *objp)
{
  struct g_main *gmain = vmain;
  struct g_obj_dirsel *gobj;
  struct vg3_actionstack_elem actionp;

  if (gmain == NULL || objp == NULL) { return; }

  actionp = VG3_actionstack_get(gmain->game.astck);

  gobj = (struct g_obj_dirsel *)objp->ostruct;

  /* relevant? */
  if (actionp.stack_id == 0) { gobj->keysdiscarded = 0; return; }
  if (actionp.name_id != UART_DIRSEL) { gobj->keysdiscarded = 0; return; }

  if (!gobj->keysdiscarded) { VG3_discard_input(gmain->wstruct); gobj->keysdiscarded = 1; }

  if (VG3_keys_key_ispressed(gmain->skeys, gmain->nwptr, 0, 0, KEYDEF_GO_LEFT, VGAG3_IS_NEW_PRESSED)) {
    actionp = VG3_actionstack_parent(gmain->game.astck);
    if (actionp.stack_id > 0 && actionp.name_id == UART_MOVSMURF) {
      VG3_hash_setint(actionp.hparm, "direction", sizeof("direction"), 1);
      VG3_actionstack_pop(gmain->game.astck);
    }
  }
  if (VG3_keys_key_ispressed(gmain->skeys, gmain->nwptr, 0, 0, KEYDEF_GO_RIGHT, VGAG3_IS_NEW_PRESSED)) {
    actionp = VG3_actionstack_parent(gmain->game.astck);
    if (actionp.stack_id > 0 && actionp.name_id == UART_MOVSMURF) {
      VG3_hash_setint(actionp.hparm, "direction", sizeof("direction"), 2);
      VG3_actionstack_pop(gmain->game.astck);
    }
  }
}


/* draw-function */
static void
f_draw(void *vmain, struct vg3_ofunc_object *objp)
{
  struct g_main *gmain = vmain;
  struct g_obj_dirsel *gobj;
  struct vg3_actionstack_elem actionp;

  if (gmain == NULL || objp == NULL) { return; }

  actionp = VG3_actionstack_get(gmain->game.astck);

  /* relevant? */
  if (actionp.stack_id == 0) { return; }
  if (actionp.name_id != UART_DIRSEL) { return; }

  gobj = (struct g_obj_dirsel *)objp->ostruct;

  /* draw dirsel-instance */
  VG3_image_copy(gmain->wstruct, NULL, gobj->img_shd, gmain->winw / 2 + 15, gmain->winh / 2 + 15, NULL, 0);
  VG3_image_copy(gmain->wstruct, NULL, gobj->img, gmain->winw / 2, gmain->winh / 2, NULL, 0);
}
