#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-music.h"

void getofc_music(struct vg3_ofunc_objfunc *);

static struct vg3_ofunc_object * f_new(void *, unsigned int, ...);
static void f_free(void *, struct vg3_ofunc_object *);
static void f_run(void *, struct vg3_ofunc_object *);


/* +++ get-function +++ */

void
getofc_music(struct vg3_ofunc_objfunc *ofc)
{
  if (ofc == NULL) { return; }

  snprintf(ofc->oid, sizeof(ofc->oid), "%s", get_oid_name(OID_NAME_MUSIC));
  ofc->f_new = f_new;
  ofc->f_free = f_free;
  ofc->f_run = f_run;
}


/* +++ object-instance-functions +++ */

/* new-function
 * variable parameter: none
 */
static struct vg3_ofunc_object *
f_new(void *vmain, unsigned int iparent, ...)
{
  struct g_main *gmain = vmain;
  struct vg3_ofunc_object *objp;
  struct g_obj_music *gobj;
  va_list ap;

  if (gmain == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return NULL; }

  /* get arguments */
  va_start(ap, iparent);
  va_end(ap);

  /* create private struct for object */
  gobj = calloc(1, sizeof(*gobj));
  if (gobj == NULL) { VG3_seterror(ENOMEM, strerror(errno)); return NULL; }

  gobj->mus_papablue = VG3_audio_load(gmain->wstruct, FILES_DIR "/sound/mus_papablue.mid", 30, VGAG3_AUDIO_VOLUME_MUSIC);
  if (gobj->mus_papablue == 0) { return NULL; }

  gobj->mus_papablack = VG3_audio_load(gmain->wstruct, FILES_DIR "/sound/mus_papablack.mid", 30, VGAG3_AUDIO_VOLUME_MUSIC);
  if (gobj->mus_papablack == 0) { return NULL; }

  /* create and fill music-instance */
  objp = calloc(1, sizeof(*objp));
  if (objp == NULL) { VG3_seterror(ENOMEM, strerror(errno)); return NULL; }
  snprintf(objp->oid, sizeof(objp->oid), "%s", get_oid_name(OID_NAME_MUSIC));
  objp->drawlevel = 1;
  objp->instanceid = 0;  /* will be set in VG3_ofunc_objlist_insert() */
  objp->ostruct = gobj;

  /* insert music-instance into list of object-instances */
  VG3_ofunc_objlist_insert(gmain->ofstruct, objp);

  return objp;
}


/* free-function */
static void
f_free(void *vmain, struct vg3_ofunc_object *objp)
{
  struct g_main *gmain = vmain;
  struct g_obj_music *gobj;

  if (gmain == NULL || objp == NULL) { return; }

  gobj = (struct g_obj_music *)objp->ostruct;

  /* remove music-instance from list of object-instances */
  VG3_ofunc_objlist_remove(gmain->ofstruct, objp);

  /* free music-instance */
  if (gobj->mus_papablue > 0) { VG3_audio_unload(gmain->wstruct, gobj->mus_papablue); }
  if (gobj->mus_papablack > 0) { VG3_audio_unload(gmain->wstruct, gobj->mus_papablack); }
  free(gobj);
  free(objp);
}


/* run-function */
static void
f_run(void *vmain, struct vg3_ofunc_object *objp)
{
  struct g_main *gmain = vmain;
  struct g_obj_music *gobj;
  int papa_isblack;

  if (gmain == NULL || objp == NULL) { return; }

  gobj = (struct g_obj_music *)objp->ostruct;

  if (VG3_ofunc_objlist_find_subobj(gmain->ofstruct, get_oid_name(OID_NAME_SMURF), SPECIES_PAPASMURF_BLACK, NULL) > 0) {
    papa_isblack = 1;
  } else {
    papa_isblack = 0;
  }

  if (papa_isblack) {
    if (gobj->mus_playing != gobj->mus_papablack) {
      if (gobj->mus_playing > 0) { VG3_audio_stop(gmain->wstruct, gobj->mus_playing, 1); }
      gobj->mus_playing = gobj->mus_papablack;
      VG3_audio_play(gmain->wstruct, gobj->mus_playing, 2, 1);
    }
  } else {
    if (gobj->mus_playing != gobj->mus_papablue) {
      if (gobj->mus_playing > 0) { VG3_audio_stop(gmain->wstruct, gobj->mus_playing, 1); }
      gobj->mus_playing = gobj->mus_papablue;
      VG3_audio_play(gmain->wstruct, gobj->mus_playing, 2, 1);
    }
  }
}
