#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-mousesel.h"
#include "obj-smurf.h"

void getoofc_mousesel_smurf(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_mousesel_smurf(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_MOUSESEL));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_SMURF));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct vg3_ofunc_object *objp_mousesel, *objp_smurf;
  struct g_obj_mousesel *gobj_mousesel;
  struct g_obj_smurf *gobj_smurf;
  int mpres;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  /* get private struct of OID_NAME_MOUSESEL and OID_NAME_SMURF */
  if (strcmp(objp1->oid, get_oid_name(OID_NAME_MOUSESEL)) == 0) {
    objp_mousesel = objp1;
    objp_smurf = objp2;
  } else {
    objp_mousesel = objp2;
    objp_smurf = objp1;
  }
  gobj_smurf = (struct g_obj_smurf *)objp_smurf->ostruct;
  gobj_mousesel = (struct g_obj_mousesel *)objp_mousesel->ostruct;

  gobj_smurf->mouseover = 1;

  /* select smurf */
  if (VG3_mouse_ispressed(gmain->wstruct, &mpres, NULL, NULL, VGAG3_IS_NEW_PRESSED)) {
    gobj_mousesel->instanceid = objp_smurf->instanceid;
  }

  return VGAG3_COLL_RETURN_HIT;
}
