#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>

extern void getofc_music(struct vg3_ofunc_objfunc *);
extern void getofc_playfield(struct vg3_ofunc_objfunc *);
extern void getofc_smurf(struct vg3_ofunc_objfunc *);
extern void getofc_dice(struct vg3_ofunc_objfunc *);
extern void getofc_animation(struct vg3_ofunc_objfunc *);
extern void getofc_mousesel(struct vg3_ofunc_objfunc *);
extern void getofc_dirsel(struct vg3_ofunc_objfunc *);
extern void getoofc_mousesel_smurf(struct vg3_ofunc_objobjfunc *);
extern void getofmgmt_smurf(struct vg3_ofunc_ofmgmt *);

/* create new main-struct for object-functions */
struct vg3_ofunc * ofunc_new(void) {
  struct vg3_ofunc *ofstruct;
  struct vg3_ofunc_objvar ovar;
  struct vg3_ofunc_objfunc ofc;
  struct vg3_ofunc_objobjfunc oofc;
  struct vg3_ofunc_ofmgmt ofm;
  struct vg3_ofunc_ovkey ovkey;
  struct vg3_ofunc_okey okey;
  struct vg3_ofunc_ookey ookey;
  struct vg3_hash *h_ovar, *h_okey, *h_ookey;

  ofstruct = calloc(1, sizeof(*ofstruct));
  if (ofstruct == NULL) { return NULL; }

  ofstruct->hget = VG3_hash_new();
  ofstruct->hobj = VG3_hash_new();
  ofstruct->hiid = VG3_hash_new();
  ofstruct->hmgmt = VG3_hash_new();

  h_ovar = VG3_hash_new();
  h_okey = VG3_hash_new();
  h_ookey = VG3_hash_new();
  VG3_hash_set(ofstruct->hget, HGETSUB_OVAR, sizeof(HGETSUB_OVAR), &h_ovar, sizeof(h_ovar));
  VG3_hash_set(ofstruct->hget, HGETSUB_OKEY, sizeof(HGETSUB_OKEY), &h_okey, sizeof(h_okey));
  VG3_hash_set(ofstruct->hget, HGETSUB_OOKEY, sizeof(HGETSUB_OOKEY), &h_ookey, sizeof(h_ookey));

  (void)ovar;
  (void)ofc;
  (void)oofc;
  (void)ofm;
  (void)ovkey;
  (void)okey;
  (void)ookey;

  memset(&ofc, 0, sizeof(ofc));
  getofc_music(&ofc);
  if (*ofc.oid != '\0') {
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_playfield(&ofc);
  if (*ofc.oid != '\0') {
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_smurf(&ofc);
  if (*ofc.oid != '\0') {
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_dice(&ofc);
  if (*ofc.oid != '\0') {
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_animation(&ofc);
  if (*ofc.oid != '\0') {
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_mousesel(&ofc);
  if (*ofc.oid != '\0') {
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
  }

  memset(&ofc, 0, sizeof(ofc));
  getofc_dirsel(&ofc);
  if (*ofc.oid != '\0') {
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofc.oid);
    VG3_hash_set(h_okey, &okey, sizeof(okey), &ofc, sizeof(ofc));
  }

  memset(&oofc, 0, sizeof(oofc));
  getoofc_mousesel_smurf(&oofc);
  if (*oofc.oid1 != '\0' && *oofc.oid2 != '\0') {
    memset(&ookey, 0, sizeof(ookey));
    snprintf(ookey.oid1, sizeof(ookey.oid1), "%s", oofc.oid1);
    snprintf(ookey.oid2, sizeof(ookey.oid2), "%s", oofc.oid2);
    VG3_hash_set(h_ookey, &ookey, sizeof(ookey), &oofc, sizeof(oofc));
  }

  memset(&ofm, 0, sizeof(ofm));
  getofmgmt_smurf(&ofm);
  if (*ofm.oid != '\0') {
    memset(&okey, 0, sizeof(okey));
    snprintf(okey.oid, sizeof(okey.oid), "%s", ofm.oid);
    VG3_hash_set(ofstruct->hmgmt, &okey, sizeof(okey), &ofm, sizeof(ofm));
  }

  return ofstruct;
}
