/* create data file for levels */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <time.h>
#include "level.h"

#define ZUFALL(P1, P2)  (P1 + (rand() % (P2 - P1 + 1)))
#define FILES_DIR "files"


int main(int argc, char **argv) {
  int i1, i2;
  struct g_level level;
  FILE *ffl;

  (void)argc;
  (void)argv;

  if ((ffl = fopen(FILES_DIR "/levels.data", "w")) == NULL) {
    fprintf(stderr, "Cannot write levels.data: %s\n", strerror(errno));
    exit(1);
  }

  srand(time(NULL) % 1000);

  /* level 1 */
  memset(&level, 0, sizeof(level));
  level.bgno = 1;
  level.bgbright = 60;
  level.bgcolor = 0x6d8000;
  level.esnake_aktiv = 4;
  level.esnake_max = 15;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    level.kind[i1] = 1;
    if (i1 == level.esnake_max - 5) { level.kind[i1] = 2; }
    if (i1 == level.esnake_max - 2) { level.kind[i1] = 3; }
  }
  level.loop_newsnake = 900 + ZUFALL(50, 100);
  level.bottle_no = 2200;
  level.bottle_yes = 800;
  level.camhat_no = 3200;
  level.camhat_yes = 800;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("01:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  /* level 2 */
  memset(&level, 0, sizeof(level));
  level.bgno = 1;
  level.bgbright = 60;
  level.bgcolor = 0x498037;
  level.esnake_aktiv = 5;
  level.esnake_max = 25;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    i2 = ZUFALL(0, 100);
    if (i2 % 3 == 0) {
      i2 = 2 + ZUFALL(0, 1);
    } else {
      i2 = 1;
    }
    level.kind[i1] = i2;
  }
  level.loop_newsnake = 1000 + ZUFALL(80, 160);
  level.bottle_no = 2200;
  level.bottle_yes = 800;
  level.camhat_no = 3200;
  level.camhat_yes = 800;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("02:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  /* level 3 */
  memset(&level, 0, sizeof(level));
  level.bgno = 1;
  level.bgbright = 60;
  level.bgcolor = 0x807848;
  level.esnake_aktiv = 5;
  level.esnake_max = 20;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    i2 = ZUFALL(0, 100);
    if (i2 % 4 == 0) {
      i2 = 1;
    } else {
      i2 = 2 + ZUFALL(0, 1);
    }
    level.kind[i1] = i2;
  }
  level.loop_newsnake = 900 + ZUFALL(90, 180);
  level.bottle_no = 2000;
  level.bottle_yes = 800;
  level.camhat_no = 3000;
  level.camhat_yes = 800;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("03:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  /* level 4 */
  memset(&level, 0, sizeof(level));
  level.bgno = 1;
  level.bgbright = 60;
  level.bgcolor = 0x805b49;
  level.esnake_aktiv = 6;
  level.esnake_max = 30;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    i2 = ZUFALL(0, 100);
    if (i2 % 6 == 0) {
      i2 = 1;
    } else {
      i2 = 2 + ZUFALL(0, 1);
    }
    level.kind[i1] = i2;
    if (i1 == level.esnake_max - 2) { level.kind[i1] = 4; }
  }
  level.loop_newsnake = 1000 + ZUFALL(90, 180);
  level.bottle_no = 2200;
  level.bottle_yes = 800;
  level.camhat_no = 3400;
  level.camhat_yes = 800;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("04:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  /* level 5 */
  memset(&level, 0, sizeof(level));
  level.bgno = 1;
  level.bgbright = 60;
  level.bgcolor = 0x804949;
  level.esnake_aktiv = 5;
  level.esnake_max = 25;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    i2 = ZUFALL(0, 100);
    if (i2 % 3 == 0) {
      i2 = 2 + ZUFALL(0, 1);
    } else {
      i2 = 4;
    }
    level.kind[i1] = i2;
  }
  level.loop_newsnake = 900 + ZUFALL(75, 150);
  level.bottle_no = 2000;
  level.bottle_yes = 800;
  level.camhat_no = 2800;
  level.camhat_yes = 800;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("05:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  /* level 6 */
  memset(&level, 0, sizeof(level));
  level.bgno = 1;
  level.bgbright = 60;
  level.bgcolor = 0x804900;
  level.esnake_aktiv = 6;
  level.esnake_max = 30;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    i2 = ZUFALL(0, 100);
    if (i2 % 4 == 0) {
      i2 = 2 + ZUFALL(0, 1);
    } else {
      i2 = 4;
    }
    level.kind[i1] = i2;
    if (i1 == level.esnake_max - 2) { level.kind[i1] = 5; }
    if (i1 == level.esnake_max - 1) { level.kind[i1] = 5; }
  }
  level.loop_newsnake = 1000 + ZUFALL(75, 150);
  level.bottle_no = 2200;
  level.bottle_yes = 800;
  level.camhat_no = 2800;
  level.camhat_yes = 800;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("06:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  /* level 7 */
  memset(&level, 0, sizeof(level));
  level.bgno = 2;
  level.bgbright = 70;
  level.bgcolor = 0x804080;
  level.esnake_aktiv = 4;
  level.esnake_max = 25;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    i2 = ZUFALL(0, 100);
    if (i2 % 4 == 0) {
      i2 = 4;
    } else {
      i2 = 5;
    }
    level.kind[i1] = i2;
    if (i1 == level.esnake_max - 1) { level.kind[i1] = 6; }
  }
  level.loop_newsnake = 900 + ZUFALL(80, 160);
  level.bottle_no = 1800;
  level.bottle_yes = 800;
  level.camhat_no = 3500;
  level.camhat_yes = 800;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("07:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  /* level 8 */
  memset(&level, 0, sizeof(level));
  level.bgno = 2;
  level.bgbright = 70;
  level.bgcolor = 0x5b2580;
  level.esnake_aktiv = 5;
  level.esnake_max = 30;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    i2 = ZUFALL(0, 100);
    if (i2 % 7 == 0) {
      i2 = 4;
    } else if (i2 % 3 == 0) {
      i2 = 6;
    } else {
      i2 = 5;
    }
    level.kind[i1] = i2;
    if (i1 == level.esnake_max - 4) { level.kind[i1] = 6; }
  }
  level.loop_newsnake = 1000 + ZUFALL(80, 160);
  level.bottle_no = 1600;
  level.bottle_yes = 800;
  level.camhat_no = 3400;
  level.camhat_yes = 800;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("08:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  /* level 9 */
  memset(&level, 0, sizeof(level));
  level.bgno = 2;
  level.bgbright = 70;
  level.bgcolor = 0x134980;
  level.esnake_aktiv = 5;
  level.esnake_max = 25;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    i2 = ZUFALL(0, 100);
    if (i2 % 3 == 0) {
      i2 = 5;
    } else {
      i2 = 6;
    }
    level.kind[i1] = i2;
    if (i1 == level.esnake_max - 1) { level.kind[i1] = 7; }
  }
  level.loop_newsnake = 900 + ZUFALL(65, 130);
  level.bottle_no = 1800;
  level.bottle_yes = 800;
  level.camhat_no = 3800;
  level.camhat_yes = 800;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("09:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  /* level 10 */
  memset(&level, 0, sizeof(level));
  level.bgno = 2;
  level.bgbright = 70;
  level.bgcolor = 0x250080;
  level.esnake_aktiv = 2;
  level.esnake_max = 4;
  if (level.esnake_max > LEVEL_ESNAKE_MAX) { level.esnake_max = LEVEL_ESNAKE_MAX; }
  for (i1 = 0; i1 < level.esnake_max; i1++) {
    level.kind[i1] = 7;
  }
  level.loop_newsnake = 1500 + ZUFALL(50, 200);
  level.bottle_no = 1300;
  level.bottle_yes = 800;
  level.camhat_no = 9999;
  level.camhat_yes = 0;
  if (fwrite(&level, sizeof(level), 1, ffl) != 1) {
    fprintf(stderr, "Error writing levels.data: %s\n", strerror(errno));
    exit(1);
  }
  printf("10:"); for (i1 = 0; i1 < level.esnake_max; i1++) { printf(" %d", level.kind[i1]); }; printf("\n");

  fclose(ffl);
  printf("Write out " FILES_DIR "/levels.data\n");

#if 0
  { struct g_level *level;
    int anz_level, mom_level;
    FILE *ffl = fopen(FILES_DIR "/levels.data", "r");
    if (ffl == NULL) { fprintf(stderr, "Cannot load levels.data\n"); exit(1); }
    anz_level = 0;
    level = malloc((anz_level + 1) * sizeof(*level));
    if (level == NULL) { fprintf(stderr, "malloc: %s\n", strerror(errno)); exit(1); }
    while (fread(&level[anz_level], sizeof(*level), 1, ffl) == 1) {
      anz_level++;
      level = realloc(level, (anz_level + 1) * sizeof(*level));
      if (level == NULL) { fprintf(stderr, "realloc: %s\n", strerror(errno)); exit(1); }
    }
    fclose(ffl);
    for (mom_level = 0; mom_level < anz_level; mom_level++) {
      printf("Level %d\n", mom_level + 1);
      printf("- bgno: %d\n", level[mom_level].bgno);
      printf("- bgbright: %d\n", level[mom_level].bgbright);
      printf("- bgcolor: %d\n", level[mom_level].bgcolor);
      printf("- esnake_aktiv: %d\n", level[mom_level].esnake_aktiv);
      printf("- esnake_max: %d\n", level[mom_level].esnake_max);
      printf("- kind:");
      for (i1 = 0; i1 < level[mom_level].esnake_max; i1++) {
        printf(" %d", level[mom_level].kind[i1]);
      }
      printf("\n");
      printf("- bottle_no: %d\n", level[mom_level].bottle_no);
      printf("- bottle_yes: %d\n", level[mom_level].bottle_yes);
      printf("- camhat_no: %d\n", level[mom_level].camhat_no);
      printf("- camhat_yes: %d\n", level[mom_level].camhat_yes);
      printf("\n");
    }
    free(level);
  }
#endif

  exit(0);
}
