#ifndef MAIN_H_
#define MAIN_H_

#include <vgagames3.h>

/* object-id enumeration */
typedef enum {
  OID_NAME_WALL,
  OID_NAME_ISNAKE,
  OID_NAME_ESNAKE,
  OID_NAME_SHOT,
  OID_NAME_CAMHAT,
  OID_NAME_BOTTLE,
} OID_NAMES;

/* abstract key definitions for system-menu */
typedef enum {
  KEYDEF_GO_UP,
  KEYDEF_GO_DOWN,
  KEYDEF_GO_RIGHT,
  KEYDEF_GO_LEFT,
  KEYDEF_FIRE,
} KEYDEFS;

/* subdirectory containing extra files */
#define FILES_DIR "files"

/* only for debug purpose */
#undef SET_MARKER

/* random number from P1 to P2 inclusive */
#define ZUFALL(P1, P2)  (P1 + (rand() % (P2 - P1 + 1)))

/* game struct */
struct g_main {
  struct vg3_window *wstruct;   /* window struct */
  int winw, winh;               /* window size: width and height */
  struct vg3_multilang *mlang;  /* multi-language struct */
  struct vg3_sysmenu *sysm;     /* system-menu struct */
  struct vg3_quadtree *qdtr;    /* Quadtree */
  struct vg3_ofunc *ofstruct;   /* object function main struct */
  char *sysm_string;            /* save-string for system-menu to save on disk */
  int isnake_health;            /* health of player's snake in percent */
  int mom_level;                /* actual level (for saving) */
  struct vg3_rect grect;        /* rectangle of ground */
};


/* main.c */
extern const char * get_oid_name(int);

/* keys.c */
extern void create_input_keys(struct g_main *);
extern int key_ispressed(struct g_main *, int, int);

/* save.c */
extern void settings_savetofile(struct g_main *);
extern void settings_readfromfile(struct g_main *, int);

#endif /* MAIN_H_ */
