#ifndef OBJ_ESNAKE_H_
#define OBJ_ESNAKE_H_

typedef enum {
  ES_MOVING_DIR_UP = 0,
  ES_MOVING_DIR_RIGHT,
  ES_MOVING_DIR_DOWN,
  ES_MOVING_DIR_LEFT,
} ES_MOVING_DIRS;

struct es_limb {
  int x, y, movdir;
};

struct es_kind {
  int limb_max;
  int poison_max;
  int poison_strength;
  int moving_factor;
};

#define ESNAKE_LIMB_MAX 15

struct g_obj_esnake {
  struct es_kind kind;               /* kind of esnake */
  struct vg3_rect rect;              /* position of esnake */
  struct vg3_rect crect;             /* collision rectangle of esnake (a bit smaller than rect and constant) */
  int xdelta, ydelta;                /* moving esnake in x- and y-direction */
  int xremainder, yremainder;        /* remainders of esnake-moving */
  int keep_moving;                   /* how many loops keep moving-direction */
  int rand_poison;                   /* number for calculating random poison-shots */
  int limb_anz;                      /* actual number of esnake-limbs */
  int movdir;                        /* moving direction: ES_MOVING_DIRS */
  int poison_shots;                  /* how many poison-shots are running */
  int camhat;                        /* camouflage hat: how many loops valid */
  int dying;                         /* been eaten: how many loops */
  int snd_hit;                       /* sound, when hit */
  int snd_dead;                      /* sound, when dead */
  int snd_come;                      /* sound, when coming out */
  int limbidx[ESNAKE_LIMB_MAX];      /* index in limbstream for limbs */
  int limbstream_size;               /* size of limbstream in struct es_limb */
  int isnake_iid;                    /* instance-ID of isnake for retrieving its number of limbs */
  struct es_limb *limbstream;        /* position of every pixel of esnake limbs */
  struct vg3_image *img_head_short;  /* image of esnake-head if shorter or equal to isnake */
  struct vg3_image *img_head_long;   /* image of esnake-head if longer than isnake */
  struct vg3_image *img_eye;         /* image of esnake-eye */
  struct vg3_image *img_limb;        /* image of esnake-limb */
  struct vg3_image *img_tg[4];       /* images of esnake-tongue */
};

#endif /* OBJ_ESNAKE_H_ */
