#ifndef OBJ_ISNAKE_H_
#define OBJ_ISNAKE_H_

typedef enum {
  IS_MOVING_DIR_UP = 0,
  IS_MOVING_DIR_RIGHT,
  IS_MOVING_DIR_DOWN,
  IS_MOVING_DIR_LEFT,
} IS_MOVING_DIRS;

struct is_limb {
  int x, y, movdir;
};

#define ISNAKE_LIMB_MAX 8

struct g_obj_isnake {
  struct vg3_rect rect;          /* position of isnake */
  struct vg3_rect crect;         /* collision rectangle of isnake (a bit smaller than rect and constant) */
  int xdelta, ydelta;            /* moving isnake in x- and y-direction */
  int xremainder, yremainder;    /* remainders of isnake-moving */
  int limb_anz;                  /* actual number of isnake-limbs */
  int movdir;                    /* moving direction: IS_MOVING_DIRS */
  int poison_shot;               /* whether poison-shot is running */
  int camhat;                    /* camouflage hat: how many loops valid */
  int eating;                    /* eating an enemy snake: how many loops */
  int snd_hit;                   /* sound, when hit */
  int snd_spit;                  /* sound, when spitting poison */
  int limbidx[ISNAKE_LIMB_MAX];  /* index in limbstream for limbs */
  int limbstream_size;           /* size of limbstream in struct is_limb */
  struct is_limb *limbstream;    /* position of every pixel of isnake limbs */
  struct vg3_image *img_head;    /* image of isnake-head */
  struct vg3_image *img_dead;    /* image of dead-head */
  struct vg3_image *img_eye;     /* image of isnake-eye */
  struct vg3_image *img_limb;    /* image of isnake-limb */
  struct vg3_image *img_tg[4];   /* images of isnake-tongue */
};

#endif /* OBJ_ISNAKE_H_ */
