#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-wall.h"

void getofc_wall(struct vg3_ofunc_objfunc *);

static struct vg3_ofunc_object * f_new(void *, unsigned int, ...);
static void f_free(void *, struct vg3_ofunc_object *);


/* +++ get-function +++ */

void
getofc_wall(struct vg3_ofunc_objfunc *ofc)
{
  if (ofc == NULL) { return; }

  snprintf(ofc->oid, sizeof(ofc->oid), "%s", get_oid_name(OID_NAME_WALL));
  ofc->f_new = f_new;
  ofc->f_free = f_free;
}


/* +++ object-functions +++ */

/* new-function
 * variable parameter: struct vg3_rect *rect = position of wall
 */
static struct vg3_ofunc_object *
f_new(void *vmain, unsigned int iparent, ...)
{
  struct g_main *gmain = vmain;
  struct vg3_ofunc_object *objp;
  struct g_obj_wall *gobj;
  struct vg3_rect *rect;
  struct vg3_coll coll;
  va_list ap;

  if (gmain == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return NULL; }

  /* get arguments: rect:(struct vg3_rect *) */
  va_start(ap, iparent);
  rect = (struct vg3_rect *)va_arg(ap, void *);
  va_end(ap);

  /* create private struct for object */
  gobj = calloc(1, sizeof(*gobj));
  if (gobj == NULL) { VG3_seterror(ENOMEM, strerror(errno)); return NULL; }
  memmove(&gobj->rect, rect, sizeof(gobj->rect));

  /* create and fill wall-instance */
  objp = calloc(1, sizeof(*objp));
  if (objp == NULL) { VG3_seterror(ENOMEM, strerror(errno)); return NULL; }
  snprintf(objp->oid, sizeof(objp->oid), "%s", get_oid_name(OID_NAME_WALL));
  objp->drawlevel = 1;
  objp->instanceid = 0;  /* will be set in VG3_ofunc_objlist_insert() */
  objp->ostruct = gobj;

  /* insert wall-instance into list of object-instances */
  VG3_ofunc_objlist_insert(gmain->ofstruct, objp);

  /* insert wall-instance into quadtree */
  memset(&coll, 0, sizeof(coll));
  coll.rect = gobj->rect;
  snprintf(coll.oid, sizeof(coll.oid), "%s", get_oid_name(OID_NAME_WALL));
  coll.optr = objp;
  VG3_coll_q_insert(gmain->qdtr, &coll);

  return objp;
}


/* free-function */
static void
f_free(void *vmain, struct vg3_ofunc_object *objp)
{
  struct g_main *gmain = vmain;
  struct g_obj_wall *gobj;

  if (gmain == NULL || objp == NULL) { return; }

  gobj = (struct g_obj_wall *)objp->ostruct;

  /* remove wall-instance from quadtree */
  VG3_coll_q_remove(gmain->qdtr, objp);

  /* remove wall-instance from list of object-instances */
  VG3_ofunc_objlist_remove(gmain->ofstruct, objp);

  /* free wall-instance */
  free(gobj);
  free(objp);
}
