#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"

void getofmgmt_esnake(struct vg3_ofunc_ofmgmt *);

/* static structure for this object-managing */
static struct {
  int esnake_aktiv;   /* minimum number of active enemy snakes */
  int esnake_max;     /* number of enemy snakes in this level */
  int *kind;          /* kind of each enemy snake */
  int loop_newsnake;  /* number of loops after that a new enemy snake appears */
  int kind_pos;       /* position in kind */
  int loop_pos;       /* position in loop_newsnake */
} mgmt_esnake;

static int f_activate(void *, struct vg3_ofunc *, va_list);
static void f_deactivate(void *, struct vg3_ofunc *);
static void f_run(void *, struct vg3_ofunc *);
static int f_data(void *, struct vg3_ofunc *, void *);


/* +++ get-function +++ */

/* fill out the passed structure for object-management-functions of this VgaGames3-object */
void
getofmgmt_esnake(struct vg3_ofunc_ofmgmt *ofm) {
  if (ofm == NULL) { return; }
  snprintf(ofm->oid, sizeof(ofm->oid), "%s", get_oid_name(OID_NAME_ESNAKE));
  ofm->f_activate = f_activate;
  ofm->f_deactivate = f_deactivate;
  ofm->f_run = f_run;
  ofm->f_data = f_data;
}


/* +++ object-management-functions +++ */

/* activate the managing of esnake-object
 * parameters in ap:
 * - integer: minimum number of active enemy snakes
 * - integer: number of enemy snakes in this level
 * - integer: number of loops after that a new enemy snake appears
 * - pointer to field[number of enemy snakes in this level] of integers: kind of each enemy snake
 */
static int
f_activate(void *vmain, struct vg3_ofunc *ofstruct, va_list ap)
{
  struct g_main *gmain = vmain;
  int *kind;

  if (ofstruct == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return -1; }
  (void)gmain;

  memset(&mgmt_esnake, 0, sizeof(mgmt_esnake));

  /* get variadic parameters */
  mgmt_esnake.esnake_aktiv = va_arg(ap, int);
  mgmt_esnake.esnake_max = va_arg(ap, int);
  mgmt_esnake.loop_newsnake = va_arg(ap, int);
  kind = va_arg(ap, int *);

  if (mgmt_esnake.esnake_aktiv <= 0) { mgmt_esnake.esnake_aktiv = 0; }
  if (mgmt_esnake.esnake_max <= 0) { VG3_seterror(EINVAL, strerror(EINVAL)); return -1; }
  if (mgmt_esnake.loop_newsnake <= 10) { mgmt_esnake.loop_newsnake = 10; }
  if (kind == NULL) { VG3_seterror(EINVAL, strerror(EINVAL)); return -1; }

  mgmt_esnake.kind = calloc(mgmt_esnake.esnake_max, sizeof(int));
  if (mgmt_esnake.kind == NULL) { VG3_seterror(ENOMEM, strerror(errno)); return -1; }
  memmove(mgmt_esnake.kind, kind, sizeof(int) * mgmt_esnake.esnake_max);

  return 0;
}


/* deactivate the managing of esnake-object */
static void
f_deactivate(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;

  if (ofstruct == NULL) { return; }
  (void)gmain;

  /* now we clean up our static structure */
  if (mgmt_esnake.kind != NULL) { free(mgmt_esnake.kind); }
  memset(&mgmt_esnake, 0, sizeof(mgmt_esnake));
}


/* execute managing of esnake-instances,
 * creating a new one, if not enough esnakes are active
 */
static void
f_run(void *vmain, struct vg3_ofunc *ofstruct)
{
  struct g_main *gmain = vmain;

  if (ofstruct == NULL) { return; }
  (void)gmain;

  if (mgmt_esnake.kind_pos == mgmt_esnake.esnake_max) { return; }
  if (mgmt_esnake.loop_pos >= mgmt_esnake.loop_newsnake) { mgmt_esnake.loop_pos--; return; }

  if (++mgmt_esnake.loop_pos == mgmt_esnake.loop_newsnake) {
    const struct vg3_ofunc_objfunc *ofc;
    ofc = VG3_ofunc_get_objfunc(ofstruct, get_oid_name(OID_NAME_ESNAKE));
    if (ofc == NULL) { mgmt_esnake.kind_pos = mgmt_esnake.esnake_max; return; }
    if (ofc->f_new(vmain, 0, mgmt_esnake.kind[mgmt_esnake.kind_pos]) == NULL) {  /* create esnake-instance */
      fprintf(stderr, "%s\n", VG3_error());
      mgmt_esnake.kind_pos = mgmt_esnake.esnake_max;
      return;
    }
    mgmt_esnake.kind_pos++;
    mgmt_esnake.loop_pos = 0;

  } else {
    int enr = VG3_ofunc_objlist_find_obj(ofstruct, get_oid_name(OID_NAME_ESNAKE), NULL);
    if (enr < mgmt_esnake.esnake_aktiv) { mgmt_esnake.loop_pos = mgmt_esnake.loop_newsnake + ZUFALL(30, 90); }
  }
}


/* query remaining number of esnake-instances including active ones */
static int
f_data(void *vmain, struct vg3_ofunc *ofstruct, void *vdata)
{
  struct g_main *gmain = vmain;
  int enr;

  if (ofstruct == NULL) { return 0; }
  (void)gmain;
  (void)vdata;

  enr = mgmt_esnake.esnake_max - mgmt_esnake.kind_pos;
  enr += VG3_ofunc_objlist_find_obj(ofstruct, get_oid_name(OID_NAME_ESNAKE), NULL);

  return enr;
}
