#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-bottle.h"
#include "obj-isnake.h"

void getoofc_bottle_isnake(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_bottle_isnake(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_BOTTLE));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_ISNAKE));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct vg3_ofunc_object *objp_bottle, *objp_isnake;
  struct g_obj_isnake *gobj_isnake;
  struct g_obj_bottle *gobj_bottle;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  if (strcmp(objp1->oid, get_oid_name(OID_NAME_BOTTLE)) == 0) {
    /* bottle is running and colliding with isnake (huh?) */
    objp_bottle = objp1;
    objp_isnake = objp2;
  } else {
    /* isnake is running and colliding with bottle */
    objp_bottle = objp2;
    objp_isnake = objp1;
  }

  gobj_bottle = (struct g_obj_bottle *)objp_bottle->ostruct;
  gobj_isnake = (struct g_obj_isnake *)objp_isnake->ostruct;

  if (gobj_isnake->limb_anz < ISNAKE_LIMB_MAX) {
    /* isnake gets another limb */
    gobj_isnake->limb_anz++;
    if (gobj_bottle->snd_bottle != 0) { VG3_audio_play(gmain->wstruct, gobj_bottle->snd_bottle, 0, 0); }
    /* deactivate bottle */
    VG3_coll_q_remove(gmain->qdtr, objp_bottle);  /* remove bottle-instance from quadtree */
    gobj_bottle->bottle_loop = -gobj_bottle->bottle_no;
    return VGAG3_COLL_RETURN_HIT;
  }

  return VGAG3_COLL_RETURN_NOOP;
}
