#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-camhat.h"
#include "obj-isnake.h"

void getoofc_camhat_isnake(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_camhat_isnake(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_CAMHAT));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_ISNAKE));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct vg3_ofunc_object *objp_camhat, *objp_isnake;
  struct g_obj_isnake *gobj_isnake;
  struct g_obj_camhat *gobj_camhat;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  if (strcmp(objp1->oid, get_oid_name(OID_NAME_CAMHAT)) == 0) {
    /* camhat is running and colliding with isnake (huh?) */
    objp_camhat = objp1;
    objp_isnake = objp2;
  } else {
    /* isnake is running and colliding with camhat */
    objp_camhat = objp2;
    objp_isnake = objp1;
  }

  gobj_camhat = (struct g_obj_camhat *)objp_camhat->ostruct;
  gobj_isnake = (struct g_obj_isnake *)objp_isnake->ostruct;

  if (gobj_isnake->camhat == 0) {
    /* isnake puts camouflage hat on */
    gobj_isnake->camhat = 500;
    if (gobj_camhat->snd_camhat != 0) { VG3_audio_play(gmain->wstruct, gobj_camhat->snd_camhat, 0, 0); }
    /* deactivate camouflage hat */
    VG3_coll_q_remove(gmain->qdtr, objp_camhat);  /* remove camhat-instance from quadtree */
    gobj_camhat->camhat_loop = -gobj_camhat->camhat_no;
    return VGAG3_COLL_RETURN_HIT;
  }

  return VGAG3_COLL_RETURN_NOOP;
}
