#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-isnake.h"
#include "obj-esnake.h"

void getoofc_isnake_esnake(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_isnake_esnake(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_ISNAKE));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_ESNAKE));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct vg3_ofunc_object *objp_isnake;
  struct g_obj_esnake *gobj_esnake;
  struct g_obj_isnake *gobj_isnake;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  if (strcmp(objp1->oid, get_oid_name(OID_NAME_ISNAKE)) == 0) {
    /* isnake is running and colliding with esnake */
    objp_isnake = objp1;
    gobj_isnake = (struct g_obj_isnake *)objp1->ostruct;
    gobj_esnake = (struct g_obj_esnake *)objp2->ostruct;
  } else {
    /* esnake is running and colliding with isnake */
    objp_isnake = objp2;
    gobj_isnake = (struct g_obj_isnake *)objp2->ostruct;
    gobj_esnake = (struct g_obj_esnake *)objp1->ostruct;
  }

  if (gobj_esnake->camhat > 0) { return VGAG3_COLL_RETURN_NOOP; }

  if (gobj_isnake->camhat == 0 && gobj_esnake->limb_anz > gobj_isnake->limb_anz) {
    gobj_isnake->limb_anz -= (gobj_esnake->limb_anz - gobj_isnake->limb_anz);
    if (gobj_isnake->limb_anz <= 0) {  /* last limb destroyed: dead */
      gobj_isnake->limb_anz = 0;
      gmain->isnake_health = gobj_isnake->limb_anz * 100 / ISNAKE_LIMB_MAX;
      VG3_coll_q_remove(gmain->qdtr, objp_isnake);
    }
    if (gobj_isnake->snd_hit != 0) { VG3_audio_play(gmain->wstruct, gobj_isnake->snd_hit, 0, 0); }
  }

  if (gobj_isnake->limb_anz > 0) {
    gobj_isnake->eating = gobj_esnake->dying = gobj_esnake->limb_anz * 10;
    if (gobj_esnake->snd_dead != 0) { VG3_audio_play(gmain->wstruct, gobj_esnake->snd_dead, 0, 0); }
  }

  return VGAG3_COLL_RETURN_HIT;
}
