#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-shot.h"
#include "obj-esnake.h"

void getoofc_shot_esnake(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);
static void f_quit(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *);


/* +++ get-function +++ */

void
getoofc_shot_esnake(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_SHOT));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_ESNAKE));

  oofc->f_collision = f_collision;
  oofc->f_quit = f_quit;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct vg3_ofunc_object *objp_shot, *objp_esnake;
  struct g_obj_esnake *gobj_esnake;
  struct g_obj_shot *gobj_shot;
  const struct vg3_ofunc_objfunc *ofc_shot;
  struct vg3_ofunc_object *oparent;
  int retw = VGAG3_COLL_RETURN_NOOP;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  if (strcmp(objp1->oid, get_oid_name(OID_NAME_SHOT)) == 0) {
    /* shot is running and colliding with esnake */
    objp_shot = objp1;
    objp_esnake = objp2;
    retw = VGAG3_COLL_RETURN_DEAD;
  } else {
    /* esnake is running and colliding with shot */
    objp_shot = objp2;
    objp_esnake = objp1;
    retw = VGAG3_COLL_RETURN_HIT;
  }

  gobj_shot = (struct g_obj_shot *)objp_shot->ostruct;
  gobj_esnake = (struct g_obj_esnake *)objp_esnake->ostruct;

  if (gobj_esnake->camhat > 0) { return VGAG3_COLL_RETURN_NOOP; }

  /* if shot's parent isn't dead and esnake, esnake is being hit, and shot is being destroyed */
  oparent = VG3_ofunc_objlist_isvalid(gmain->ofstruct, gobj_shot->iparent);
  if (oparent != NULL && strcmp(oparent->oid, get_oid_name(OID_NAME_ISNAKE)) == 0) {
    gobj_esnake->limb_anz -= gobj_shot->poison_strength;
    if (gobj_esnake->limb_anz <= 0) {  /* last limb destroyed: dead */
      gobj_esnake->limb_anz = 0;
      if (gobj_esnake->snd_dead != 0) { VG3_audio_play(gmain->wstruct, gobj_esnake->snd_dead, 0, 0); }
      VG3_coll_q_remove(gmain->qdtr, objp_esnake);
    } else {
      if (gobj_esnake->snd_hit != 0) { VG3_audio_play(gmain->wstruct, gobj_esnake->snd_hit, 0, 0); }
    }
    /* change direction of esnake to anti-direction of shot */
    gobj_esnake->keep_moving = ZUFALL(50, 200);
    gobj_esnake->xremainder = gobj_esnake->yremainder = 0;
    if (gobj_shot->ydelta > 0) {
      gobj_esnake->movdir = ES_MOVING_DIR_UP;
      gobj_esnake->xdelta = 0;
      gobj_esnake->ydelta = -100;
    } else if (gobj_shot->ydelta < 0) {
      gobj_esnake->movdir = ES_MOVING_DIR_DOWN;
      gobj_esnake->xdelta = 0;
      gobj_esnake->ydelta = 100;
    } else if (gobj_shot->xdelta > 0) {
      gobj_esnake->movdir = ES_MOVING_DIR_LEFT;
      gobj_esnake->xdelta = -100;
      gobj_esnake->ydelta = 0;
    } else {
      gobj_esnake->movdir = ES_MOVING_DIR_RIGHT;
      gobj_esnake->xdelta = 100;
      gobj_esnake->ydelta = 0;
    }
    /* destroy shot */
    ofc_shot = VG3_ofunc_get_objfunc(gmain->ofstruct, objp_shot->oid);
    if (ofc_shot != NULL && ofc_shot->f_free != NULL) { ofc_shot->f_free(gmain, objp_shot); }

  } else {  /* no hit */
    retw = VGAG3_COLL_RETURN_NOOP;
  }

  return retw;
}


static void
f_quit(void *vmain, struct vg3_ofunc_object *objp, struct vg3_ofunc_object *oparent)
{
  struct g_main *gmain = vmain;
  struct g_obj_esnake *gobj_esnake;

  if (gmain == NULL || objp == NULL || oparent == NULL) { return; }

  /* valid only when objp is shot and oparent is esnake */
  if (strcmp(objp->oid, get_oid_name(OID_NAME_SHOT)) != 0) { return; }
  if (strcmp(oparent->oid, get_oid_name(OID_NAME_ESNAKE)) != 0) { return; }

  /* decrement esnake's running poison-shots */
  gobj_esnake = (struct g_obj_esnake *)oparent->ostruct;
  gobj_esnake->poison_shots--;
}
