#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-shot.h"
#include "obj-isnake.h"

void getoofc_shot_isnake(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);
static void f_quit(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *);


/* +++ get-function +++ */

void
getoofc_shot_isnake(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_SHOT));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_ISNAKE));

  oofc->f_collision = f_collision;
  oofc->f_quit = f_quit;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct vg3_ofunc_object *objp_shot, *objp_isnake;
  struct g_obj_isnake *gobj_isnake;
  struct g_obj_shot *gobj_shot;
  const struct vg3_ofunc_objfunc *ofc_shot;
  struct vg3_ofunc_object *oparent;
  int retw = VGAG3_COLL_RETURN_NOOP;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  if (strcmp(objp1->oid, get_oid_name(OID_NAME_SHOT)) == 0) {
    /* shot is running and colliding with isnake */
    objp_shot = objp1;
    objp_isnake = objp2;
    retw = VGAG3_COLL_RETURN_DEAD;
  } else {
    /* isnake is running and colliding with shot */
    objp_shot = objp2;
    objp_isnake = objp1;
    retw = VGAG3_COLL_RETURN_HIT;
  }

  gobj_shot = (struct g_obj_shot *)objp_shot->ostruct;
  gobj_isnake = (struct g_obj_isnake *)objp_isnake->ostruct;

  if (gobj_isnake->camhat > 0) { return VGAG3_COLL_RETURN_NOOP; }

  /* if shot's parent is dead or esnake, isnake is being hit, and shot is being destroyed */
  oparent = VG3_ofunc_objlist_isvalid(gmain->ofstruct, gobj_shot->iparent);
  if (oparent == NULL || strcmp(oparent->oid, get_oid_name(OID_NAME_ESNAKE)) == 0) {
    gobj_isnake->limb_anz -= gobj_shot->poison_strength;
    if (gobj_isnake->limb_anz <= 0) {  /* last limb destroyed: dead */
      gobj_isnake->limb_anz = 0;
      gmain->isnake_health = gobj_isnake->limb_anz * 100 / ISNAKE_LIMB_MAX;
      VG3_coll_q_remove(gmain->qdtr, objp_isnake);
    }
    if (gobj_isnake->snd_hit != 0) { VG3_audio_play(gmain->wstruct, gobj_isnake->snd_hit, 0, 0); }
    ofc_shot = VG3_ofunc_get_objfunc(gmain->ofstruct, objp_shot->oid);
    if (ofc_shot != NULL && ofc_shot->f_free != NULL) { ofc_shot->f_free(gmain, objp_shot); }
  } else {  /* no hit */
    retw = VGAG3_COLL_RETURN_NOOP;
  }

  return retw;
}


static void
f_quit(void *vmain, struct vg3_ofunc_object *objp, struct vg3_ofunc_object *oparent)
{
  struct g_main *gmain = vmain;
  struct g_obj_isnake *gobj_isnake;

  if (gmain == NULL || objp == NULL || oparent == NULL) { return; }

  /* valid only when objp is shot and oparent is isnake */
  if (strcmp(objp->oid, get_oid_name(OID_NAME_SHOT)) != 0) { return; }
  if (strcmp(oparent->oid, get_oid_name(OID_NAME_ISNAKE)) != 0) { return; }

  /* clear isnake's running poison-shot */
  gobj_isnake = (struct g_obj_isnake *)oparent->ostruct;
  gobj_isnake->poison_shot = 0;
}
