#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-shot.h"

void getoofc_shot_shot(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_shot_shot(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_SHOT));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_SHOT));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  struct g_obj_shot *gobj_shot1, *gobj_shot2;
  const struct vg3_ofunc_objfunc *ofc_shot;
  struct vg3_ofunc_object *oparent1, *oparent2;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  gobj_shot1 = (struct g_obj_shot *)objp1->ostruct;
  gobj_shot2 = (struct g_obj_shot *)objp2->ostruct;

  /* no collision, if parent object-IDs of both shots are equal */
  oparent1 = VG3_ofunc_objlist_isvalid(gmain->ofstruct, gobj_shot1->iparent);
  oparent2 = VG3_ofunc_objlist_isvalid(gmain->ofstruct, gobj_shot2->iparent);
  if (oparent1 == NULL || oparent2 == NULL || strcmp(oparent1->oid, oparent2->oid) == 0) { return VGAG3_COLL_RETURN_NOOP; }

  ofc_shot = VG3_ofunc_get_objfunc(gmain->ofstruct, objp1->oid);
  if (ofc_shot != NULL && ofc_shot->f_free != NULL) {
    ofc_shot->f_free(gmain, objp1);
    ofc_shot->f_free(gmain, objp2);
  }

  return VGAG3_COLL_RETURN_DEAD;
}
