#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"
#include "obj-shot.h"
#include "obj-wall.h"

void getoofc_shot_wall(struct vg3_ofunc_objobjfunc *);

static int f_collision(void *, struct vg3_ofunc_object *, struct vg3_ofunc_object *, struct vg3_coll_ret *);


/* +++ get-function +++ */

void
getoofc_shot_wall(struct vg3_ofunc_objobjfunc *oofc)
{
  snprintf(oofc->oid1, sizeof(oofc->oid1), "%s", get_oid_name(OID_NAME_SHOT));
  snprintf(oofc->oid2, sizeof(oofc->oid2), "%s", get_oid_name(OID_NAME_WALL));

  oofc->f_collision = f_collision;
}


/* +++ object-to-object-functions +++ */

/* collision-function */
static int
f_collision(void *vmain, struct vg3_ofunc_object *objp1, struct vg3_ofunc_object *objp2, struct vg3_coll_ret *collret)
{
  struct g_main *gmain = vmain;
  const struct vg3_ofunc_objfunc *ofc;
  int retw = VGAG3_COLL_RETURN_NOOP;

  if (gmain == NULL || objp1 == NULL || objp2 == NULL || collret == NULL) { return VGAG3_COLL_RETURN_NOOP; }

  if (strcmp(objp1->oid, get_oid_name(OID_NAME_SHOT)) == 0) {
    /* shot is running and colliding with wall */
    ofc = VG3_ofunc_get_objfunc(gmain->ofstruct, objp1->oid);
    if (ofc != NULL && ofc->f_free != NULL) { ofc->f_free(gmain, objp1); }
    retw = VGAG3_COLL_RETURN_DEAD;
  } else {
    /* wall is running and colliding with shot (huh?) */
    ofc = VG3_ofunc_get_objfunc(gmain->ofstruct, objp2->oid);
    if (ofc != NULL && ofc->f_free != NULL) { ofc->f_free(gmain, objp2); }
    retw = VGAG3_COLL_RETURN_HIT;
  }

  return retw;
}
