#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <errno.h>
#include <vgagames3.h>
#include "main.h"

void settings_savetofile(struct g_main *);
void settings_readfromfile(struct g_main *, int);

static char * get_file(void);


/* get name of save-file */
static char *
get_file(void)
{
  static char svfile[256] = "";

  if (*svfile == '\0') {
    char *home;
    if ((home = getenv("HOME")) == NULL) { home = "."; }
    snprintf(svfile, sizeof(svfile), "%s/.VgaGames3", home);
    mkdir(svfile, 0755);
    snprintf(svfile, sizeof(svfile), "%s/.VgaGames3/snakes", home);
  }

  return svfile;
}


/* write system-menu and other settings to save-file */
void
settings_savetofile(struct g_main *gmain)
{
  FILE *ffp;
  int ival;

  if (gmain == NULL || gmain->wstruct == NULL) { return; }

  if ((ffp = fopen(get_file(), "w")) == NULL) { return; }

  /* write window-setting */
  ival = VG3_window_change(gmain->wstruct, -1);
  fprintf(ffp, "%d\n", ival);

  /* write volume-settings */
  ival = VG3_audio_volume(gmain->wstruct, VGAG3_AUDIO_VOLUME_ALL, -1);
  fprintf(ffp, "%d\n", ival);
  ival = VG3_audio_volume(gmain->wstruct, VGAG3_AUDIO_VOLUME_SOUND, -1);
  fprintf(ffp, "%d\n", ival);
  ival = VG3_audio_volume(gmain->wstruct, VGAG3_AUDIO_VOLUME_MUSIC, -1);
  fprintf(ffp, "%d\n", ival);
  ival = VG3_audio_volume(gmain->wstruct, VGAG3_AUDIO_VOLUME_SPEECH, -1);
  fprintf(ffp, "%d\n", ival);
  ival = VG3_audio_mute(gmain->wstruct, -1);
  fprintf(ffp, "%d\n", ival);

  /* write input-device settings */
  fprintf(ffp, "%s\n", (gmain->sysm_string == NULL ? "" : gmain->sysm_string));
  
  /* write actual game state */ 
  fprintf(ffp, "%d\n", gmain->isnake_health);
  fprintf(ffp, "%d\n", gmain->mom_level + 1);
  
  fclose(ffp);
}


/* read system-menu and other settings from save-file */
void
settings_readfromfile(struct g_main *gmain, int initial)
{
  FILE *ffp;
  int ival;
  char buf[1024];
  size_t blen;

  if (gmain == NULL || gmain->wstruct == NULL) { return; }

  if ((ffp = fopen(get_file(), "r")) == NULL) { return; }

  /* read in window-setting */
  if (fgets(buf, sizeof(buf), ffp) == NULL) { fclose(ffp); return; }
  ival = atoi(buf);
  VG3_window_change(gmain->wstruct, ival);

  /* read and set volume-settings */
  /* all */
  if (fgets(buf, sizeof(buf), ffp) == NULL) { fclose(ffp); return; }
  ival = atoi(buf);
  VG3_audio_volume(gmain->wstruct, VGAG3_AUDIO_VOLUME_ALL, ival);
  /* sound */
  if (fgets(buf, sizeof(buf), ffp) == NULL) { fclose(ffp); return; }
  ival = atoi(buf);
  VG3_audio_volume(gmain->wstruct, VGAG3_AUDIO_VOLUME_SOUND, ival);
  /* music */
  if (fgets(buf, sizeof(buf), ffp) == NULL) { fclose(ffp); return; }
  ival = atoi(buf);
  VG3_audio_volume(gmain->wstruct, VGAG3_AUDIO_VOLUME_MUSIC, ival);
  /* speech */
  if (fgets(buf, sizeof(buf), ffp) == NULL) { fclose(ffp); return; }
  ival = atoi(buf);
  VG3_audio_volume(gmain->wstruct, VGAG3_AUDIO_VOLUME_SPEECH, ival);
  /* mute */
  if (fgets(buf, sizeof(buf), ffp) == NULL) { fclose(ffp); return; }
  ival = atoi(buf);
  VG3_audio_mute(gmain->wstruct, ival);

  if (initial) { fclose(ffp); return; }

  /* read input-device settings */
  if (fgets(buf, sizeof(buf), ffp) == NULL) { fclose(ffp); return; }
  blen = strlen(buf);
  if (blen > 0 && buf[blen - 1] == '\n') { blen--; }
  if (blen > 0 && buf[blen - 1] == '\r') { blen--; }
  buf[blen] = '\0';
  gmain->sysm_string = strdup(buf);

  /* read last game state */ 
  if (fgets(buf, sizeof(buf), ffp) == NULL) { fclose(ffp); return; }
  gmain->isnake_health = atoi(buf);
  if (fgets(buf, sizeof(buf), ffp) == NULL) { fclose(ffp); return; }
  gmain->mom_level = atoi(buf);

  fclose(ffp);
}
