#ifndef GAMESKEL_H_
#define GAMESKEL_H_

#include "menu_helper.h"


/* +++ define appearance +++ */

/* vgaversion (VGAG3_VGAVERSIONS) */
#define GAMESKEL_VGAVERSION  VGAG3_VGAVERSION_LOW_FULLCOLOR

/* scaling (VGAG3_WINSCALES) */
#define GAMESKEL_SCALING  VGAG3_WINSCALE_BESTSCALE

/* game menus (parameters for mh_init()) */
#define GAMESKEL_GAMEMENU_BGFILE    NULL
#define GAMESKEL_GAMEMENU_BGBRIGHT  0
#define GAMESKEL_GAMEMENU_MENUFC    VGAG3_COLOR_YELLOW
#define GAMESKEL_GAMEMENU_MENUBC    VGAG3_COLOR_BLUE
#define GAMESKEL_GAMEMENU_ONLEFT    1
#define GAMESKEL_GAMEMENU_TEXTFC    VGAG3_COLOR_YELLOW
#define GAMESKEL_GAMEMENU_TEXTBC    VGAG3_COLOR_TRANSPARENT

/* help menu (foreground- and background-color) */
#define GAMESKEL_HELPMENU_FC        VGAG3_COLOR_PINK
#define GAMESKEL_HELPMENU_BC        VGAG3_COLOR_BLACK

/* system menu (color-parameters for VG3_sysmenu_new()) */
#define GAMESKEL_SYSMENU_FCNORMAL   VG3_color_brightness(VGAG3_COLOR_GREEN, 50)
#define GAMESKEL_SYSMENU_FCSELECT   VGAG3_COLOR_GREEN

/* topten list */
#define GAMESKEL_TOPTEN             /* whether show topten */
#define GAMESKEL_TOPTEN_BGFILE      NULL

/* main menu: selections for starting game
 * - 1 = local game: just "start game"
 * - 2 = local game: "start game" and "continue saved game"
 * - 3 = local or network game
 */
#define GAMESKEL_STARTING  2


/* +++ name of savefile +++ */
#define SVFILE_NAME "spacefight"


/* +++ loop-time waiting in msec +++ */
#define LOOP_TIME  50


/* +++ maximum number of players +++ */
#define MAX_PLAYERS 1


/* +++ object-ID enumeration +++ */
typedef enum {
  OID_NAME_BG,
  OID_NAME_TEXT,
  OID_NAME_PLAYER,
  OID_NAME_PLAYERSHOT,
  OID_NAME_FIGHTER,
  OID_NAME_FIGHTERSHOT,
  OID_NAME_RADAR,
  OID_NAME_MINE,
  OID_NAME_TANKER,
  OID_NAME_BOMBER,
  OID_NAME_ESCORT,
  OID_NAME_CARGOSHIP,
  OID_NAME_FACTORY,
  OID_NAME_ASTEROID,
  OID_NAME_BATTLESHIP,
  OID_NAME_MOTHERSHIP,
  OID_NAME_MOTHERSHOT,
} OID_NAMES;


/* +++ abstract key definitions for system-menu +++ */
typedef enum {
  KEYDEF_GO_FORWARD,
  KEYDEF_GO_BACKWARD,
  KEYDEF_GO_UP,
  KEYDEF_GO_DOWN,
  KEYDEF_FIRE_LASER,
  KEYDEF_FIRE_TORPEDO,
} KEYDEFS;


/* +++ game enumerations +++ */
enum { PLAYERSHOT_SHOT = 1, PLAYERSHOT_TORPEDO };
enum { FIGHTER_GREEN = 1, FIGHTER_STEALTH, FIGHTER_YELLOW, FIGHTER_RED };
enum { FDATA_REINIT = 1, FDATA_TORPEDO, FDATA_PAUSE, FDATA_FREQ, FDATA_HIT, FDATA_RATIO, FDATA_DONE, FDATA_TEXT, FDATA_POS };


/* +++ individual game struct +++ */
#include "random_check.h"
#include "levelact.h"
#include "misc.h"

struct fdata_number {
  int flag;
  int number1;
  int number2;
  int number3;
  int number4;
  int number5;
  int number6;
  int number7;
  const char *text;
};

struct g_game {
  struct {
    unsigned int player;  /* instance-ID of player */
    unsigned int text;    /* instance-ID of text-object */
  } instanceid;
  int level_retval;                /* 0 = level running, 1 = level done, 2 = redo level, -1 = level failed */
  int loop_max, loop_counter;      /* for duration of level */
  int hitratio, hitdiv;            /* hit ratio: percent and divisor */
  int hitratio_save, hitdiv_save;  /* hit ratio to save: percent and divisor */
  struct vg3_quadtree *qdtr_long;  /* quadtree for long-distance collision */
  char btim[32];                   /* text for remaining time */
  char text[128];                  /* text for infos on window */
  int muskz;                       /* music descriptor */
};


/* +++ external functions +++ */

/* gameskel.c */
extern const char * get_oid_name(int);
extern int gameskel_intro(struct vg3_window *);
extern void gameskel_setkeys(void *, struct vg3_sysmenu_submenu *, struct vg3_sysmenu_submenu *);
extern void gameskel_beforelevels(void *, struct menu_helper *);
extern int gameskel_levelstart(void *);
extern int gameskel_leveldone(void *);
extern void gameskel_levelstop(void *);
extern void gameskel_afterlevels(void *, struct menu_helper *);
extern void gameskel_settingsread(void *, FILE *);
extern void gameskel_settingssave(void *, FILE *);
extern void gameskel_settingsreset(void *);

#endif /* GAMESKEL_H_ */
