#ifndef OBJ_PLAYER_H_
#define OBJ_PLAYER_H_

struct g_obj_player {
  struct vg3_rect rect, crect;     /* rectangle and collision-rectangle */
  int xdelta, ydelta;              /* moving in x- and y-direction */
  int xremainder, yremainder;      /* remainders of moving */
  struct {                         /* images and sprites */
    struct vg3_image *img_normal;    /* normal image */
    struct vg3_image *img_up;        /* image when moving upwards */
    struct vg3_image *img_down;      /* image when moving downwards */
    struct vg3_sprite *exhaust;      /* exhaust sprite */
    struct vg3_sprite *hit;          /* hit sprite */
    struct vg3_sprite *expl;         /* exploding sprite */
  } images;
  struct {                         /* images for actual drawing */
    struct vg3_image *img;           /* pointer to image */
    int exhaust;                     /* whether to draw exhaust sprite */
    int hit;                         /* whether to draw hit sprite */
  } draw;
  int health;                      /* health */
  int shot_running;                /* how many shots are running */
  int torpedo_running;             /* how many torpedos are running */
  int torpedo_strength;            /* strength of torpedo or 0 = torpedo deactivated */
  int hitkz;                       /* hit-audio descriptor */
};

#endif /* OBJ_PLAYER_H_ */
